/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class EventBaseJsonSerializer
implements JsonSerializer<EventBase> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_START_DATE = "startDate";
    public static final String FIELD_END_DATE = "endDate";
    public static final String FIELD_VENUE = "venue";
    public static final String FIELD_IMAGE_SIZES = "imageSizes";
    public static final String FIELD_IMAGE_URL = "imageURL";
    public static final String FIELD_IMAGE_WIDTH = "imageWidth";
    public static final String FIELD_IMAGE_HEIGHT = "imageHeight";
    public static final String FIELD_VIDEO_URL = "videoURL";
    public static final String FIELD_OFFICIAL_WEBSITE_URL = "officialWebsiteURL";
    public static final String FIELD_BASE_URL = "baseURL";
    public static final String FIELD_SAILORS_INFO_WEBSITE_URLS = "sailorsInfoWebsiteURLs";
    public static final String FIELDS_LEADERBOARD_GROUPS = "leaderboardGroups";
    public static final String FIELD_SOURCE_URL = "sourceURL";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_SUBTITLE = "subtitle";
    public static final String FIELD_MIMETYPE = "mimetype";
    public static final String FIELD_COPYRIGHT = "copyright";
    public static final String FIELD_CREATEDATDATE = "createdAtDate";
    public static final String FIELD_LOCALE = "locale";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_TRACKING_CONNECTOR_INFOS = "trackingConnectorInfos";
    public static final String FIELD_IMAGES = "images";
    public static final String FIELD_IMAGE_WIDTH_IN_PX = "widthInPixel";
    public static final String FIELD_IMAGE_HEIGHT_IN_PX = "heightInPixel";
    public static final String FIELD_VIDEOS = "videos";
    public static final String FIELD_VIDEO_THUMBNAIL_URL = "thumbnailURL";
    public static final String FIELD_VIDEO_LENGTH_IN_SECONDS = "lengthInSeconds";
    public static final String FIELD_URL = "url";
    private final JsonSerializer<Venue> venueSerializer;
    private final JsonSerializer<? super LeaderboardGroupBase> leaderboardGroupBaseSerializer;
    private final JsonSerializer<TrackingConnectorInfo> trackingConnectorInfoSerializer;

    public EventBaseJsonSerializer(JsonSerializer<Venue> venueSerializer, JsonSerializer<? super LeaderboardGroupBase> leaderboardGroupBaseSerializer, JsonSerializer<TrackingConnectorInfo> trackingConnectorInfoJsonSerializer) {
        this.leaderboardGroupBaseSerializer = leaderboardGroupBaseSerializer;
        this.venueSerializer = venueSerializer;
        this.trackingConnectorInfoSerializer = trackingConnectorInfoJsonSerializer;
    }

    public JSONObject serialize(EventBase event) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_ID, (Object)event.getId().toString());
        result.put((Object)FIELD_NAME, (Object)event.getName());
        result.put((Object)FIELD_DESCRIPTION, (Object)event.getDescription());
        result.put((Object)FIELD_OFFICIAL_WEBSITE_URL, event.getOfficialWebsiteURL() != null ? event.getOfficialWebsiteURL().toString() : null);
        result.put((Object)FIELD_BASE_URL, event.getBaseURL() != null ? event.getBaseURL().toString() : null);
        result.put((Object)FIELD_START_DATE, event.getStartDate() != null ? Long.valueOf(event.getStartDate().asMillis()) : null);
        result.put((Object)FIELD_END_DATE, event.getStartDate() != null ? Long.valueOf(event.getEndDate().asMillis()) : null);
        result.put((Object)FIELD_VENUE, (Object)this.venueSerializer.serialize((Object)event.getVenue()));
        JSONArray leaderboardGroups = new JSONArray();
        result.put((Object)FIELDS_LEADERBOARD_GROUPS, (Object)leaderboardGroups);
        for (LeaderboardGroupBase lg : event.getLeaderboardGroups()) {
            leaderboardGroups.add((Object)this.leaderboardGroupBaseSerializer.serialize((Object)lg));
        }
        JSONArray trackingConnectorInfos = new JSONArray();
        for (TrackingConnectorInfo trackingConnectorInfo : event.getTrackingConnectorInfos()) {
            trackingConnectorInfos.add((Object)this.trackingConnectorInfoSerializer.serialize((Object)trackingConnectorInfo));
        }
        result.put((Object)FIELD_TRACKING_CONNECTOR_INFOS, (Object)trackingConnectorInfos);
        JSONArray imageSizes = new JSONArray();
        result.put((Object)FIELD_IMAGE_SIZES, (Object)imageSizes);
        for (ImageDescriptor image : event.getImages()) {
            this.addImageSize(image, imageSizes);
        }
        JSONArray jsonImages = new JSONArray();
        for (ImageDescriptor imageDescriptor : event.getImages()) {
            this.addImage(imageDescriptor, jsonImages);
        }
        result.put((Object)FIELD_IMAGES, (Object)jsonImages);
        JSONArray jsonVideos = new JSONArray();
        for (VideoDescriptor videoDescriptor : event.getVideos()) {
            this.addVideo(videoDescriptor, jsonVideos);
        }
        result.put((Object)FIELD_VIDEOS, (Object)jsonVideos);
        JSONArray jsonSailorsInfoWebsiteURLs = new JSONArray();
        for (Map.Entry entry : event.getSailorsInfoWebsiteURLs().entrySet()) {
            this.addSailorsInfoWebsiteURL((Locale)entry.getKey(), (URL)entry.getValue(), jsonSailorsInfoWebsiteURLs);
        }
        result.put((Object)FIELD_SAILORS_INFO_WEBSITE_URLS, (Object)jsonSailorsInfoWebsiteURLs);
        return result;
    }

    private void addImage(ImageDescriptor image, JSONArray imagesJson) {
        JSONObject imageJson = new JSONObject();
        imageJson.put((Object)FIELD_SOURCE_URL, (Object)image.getURL().toString());
        imageJson.put((Object)FIELD_LOCALE, image.getLocale() != null ? image.getLocale().getLanguage() : null);
        imageJson.put((Object)FIELD_TITLE, (Object)image.getTitle());
        imageJson.put((Object)FIELD_SUBTITLE, (Object)image.getSubtitle());
        imageJson.put((Object)FIELD_MIMETYPE, (Object)image.getMimeType().name());
        imageJson.put((Object)FIELD_COPYRIGHT, (Object)image.getCopyright());
        imageJson.put((Object)FIELD_IMAGE_WIDTH_IN_PX, (Object)image.getWidthInPx());
        imageJson.put((Object)FIELD_IMAGE_HEIGHT_IN_PX, (Object)image.getHeightInPx());
        imageJson.put((Object)FIELD_CREATEDATDATE, (Object)image.getCreatedAtDate().asMillis());
        JSONArray tags = new JSONArray();
        for (String tag : image.getTags()) {
            tags.add((Object)tag);
        }
        imageJson.put((Object)FIELD_TAGS, (Object)tags);
        imagesJson.add((Object)imageJson);
    }

    private void addVideo(VideoDescriptor video, JSONArray videosJson) {
        JSONObject videoJson = new JSONObject();
        videoJson.put((Object)FIELD_SOURCE_URL, (Object)video.getURL().toString());
        videoJson.put((Object)FIELD_LOCALE, video.getLocale() != null ? video.getLocale().getLanguage() : null);
        videoJson.put((Object)FIELD_VIDEO_THUMBNAIL_URL, video.getThumbnailURL() != null ? video.getThumbnailURL().toString() : null);
        videoJson.put((Object)FIELD_TITLE, (Object)video.getTitle());
        videoJson.put((Object)FIELD_SUBTITLE, (Object)video.getSubtitle());
        videoJson.put((Object)FIELD_MIMETYPE, (Object)video.getMimeType().name());
        videoJson.put((Object)FIELD_COPYRIGHT, (Object)video.getCopyright());
        videoJson.put((Object)FIELD_VIDEO_LENGTH_IN_SECONDS, (Object)video.getLengthInSeconds());
        videoJson.put((Object)FIELD_CREATEDATDATE, (Object)video.getCreatedAtDate().asMillis());
        JSONArray tags = new JSONArray();
        for (String tag : video.getTags()) {
            tags.add((Object)tag);
        }
        videoJson.put((Object)FIELD_TAGS, (Object)tags);
        videosJson.add((Object)videoJson);
    }

    private void addImageSize(ImageDescriptor image, JSONArray imageSizes) {
        if (image.getHeightInPx() != null && image.getWidthInPx() != null) {
            JSONObject imageSizeJson = new JSONObject();
            imageSizes.add((Object)imageSizeJson);
            imageSizeJson.put((Object)FIELD_IMAGE_URL, (Object)image.getURL().toString());
            imageSizeJson.put((Object)FIELD_IMAGE_WIDTH, (Object)image.getWidthInPx());
            imageSizeJson.put((Object)FIELD_IMAGE_HEIGHT, (Object)image.getHeightInPx());
        }
    }

    private void addSailorsInfoWebsiteURL(Locale locale, URL url, JSONArray jsonSailorsInfoWebsiteURLs) {
        JSONObject jsonSailorsInfoWebsiteURL = new JSONObject();
        jsonSailorsInfoWebsiteURL.put((Object)FIELD_LOCALE, (Object)(locale != null ? locale.getLanguage() : null));
        jsonSailorsInfoWebsiteURL.put((Object)FIELD_URL, (Object)url.toString());
        jsonSailorsInfoWebsiteURLs.add((Object)jsonSailorsInfoWebsiteURL);
    }
}

