/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.json.simple.JSONObject;

public class DetailedRaceInfoJsonSerializer
implements JsonSerializer<DetailedRaceInfo>,
JsonDeserializer<DetailedRaceInfo> {
    public static final String FIELD_EVENT_ID = "eventID";
    public static final String FIELD_EVENT_NAME = "eventName";
    public static final String FIELD_EVENT_TYPE = "eventType";
    public static final String FIELD_LEADERBOARD_NAME = "leaderboardName";
    public static final String FIELD_LEADERBOARD_DISPLAY_NAME = "leaderboardDisplayName";
    public static final String FIELD_REMOTEURL = "remoteUrl";
    public static final String FIELD_RACES = "races";

    public JSONObject serialize(DetailedRaceInfo object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_EVENT_ID, (Object)object.getEventID().toString());
        result.put((Object)FIELD_EVENT_NAME, (Object)object.getEventName());
        result.put((Object)FIELD_EVENT_TYPE, object.getEventType() == null ? null : object.getEventType().toString());
        result.put((Object)"raceName", (Object)object.getIdentifier().getRaceName());
        result.put((Object)"regattaName", (Object)object.getIdentifier().getRegattaName());
        result.put((Object)FIELD_LEADERBOARD_NAME, (Object)object.getLeaderboardName());
        result.put((Object)FIELD_LEADERBOARD_DISPLAY_NAME, (Object)object.getLeaderboardDisplayName());
        result.put((Object)"startOfRaceAsMillis", (Object)object.getStartOfRace().asMillis());
        URL remoteUrl = object.getRemoteUrl();
        result.put((Object)FIELD_REMOTEURL, (Object)(remoteUrl == null ? null : remoteUrl.toExternalForm()));
        return result;
    }

    public DetailedRaceInfo deserialize(JSONObject object) throws JsonDeserializationException {
        String eventId = object.get((Object)FIELD_EVENT_ID).toString();
        String raceName = object.get((Object)"raceName").toString();
        String regattaName = object.get((Object)"regattaName").toString();
        String leaderboardName = object.get((Object)FIELD_LEADERBOARD_NAME).toString();
        Object leaderboardDisplayNameJson = object.get((Object)FIELD_LEADERBOARD_DISPLAY_NAME);
        String leaderboardDisplayName = leaderboardDisplayNameJson == null ? null : leaderboardDisplayNameJson.toString();
        Object eventNameJson = object.get((Object)FIELD_EVENT_NAME);
        String eventName = eventNameJson == null ? null : eventNameJson.toString();
        Object typeJson = object.get((Object)FIELD_EVENT_TYPE);
        EventType type = typeJson == null ? null : EventType.valueOf((String)typeJson.toString());
        MillisecondsTimePoint startOfRace = new MillisecondsTimePoint(((Number)object.get((Object)"startOfRaceAsMillis")).longValue());
        String remoteUrl = (String)object.get((Object)FIELD_REMOTEURL);
        URL remoteUrlObj = null;
        if (remoteUrl != null && !remoteUrl.isEmpty()) {
            try {
                remoteUrlObj = new URL(remoteUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return new DetailedRaceInfo((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regattaName, raceName), leaderboardName, leaderboardDisplayName, (TimePoint)startOfRace, UUID.fromString(eventId), eventName, type, remoteUrlObj);
    }
}

