/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartTimeEventImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.RaceLogRaceStatusEventDeserializer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.json.simple.JSONObject;

public class RaceLogStartTimeEventDeserializer
extends RaceLogRaceStatusEventDeserializer {
    public RaceLogStartTimeEventDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer) {
        super(competitorDeserializer);
    }

    @Override
    protected RaceLogEvent deserialize(JSONObject object, Serializable id, TimePoint createdAt, AbstractLogEventAuthor author, TimePoint timePoint, int passId, List<Competitor> competitors) throws JsonDeserializationException {
        long startTime = (Long)object.get((Object)"startTime");
        String courseAreaIdAsString = (String)object.get((Object)"courseAreaIdAsString");
        UUID courseAreaId = courseAreaIdAsString != null ? UUID.fromString(courseAreaIdAsString) : null;
        RaceLogRaceStatusEvent event = (RaceLogRaceStatusEvent)super.deserialize(object, id, createdAt, author, timePoint, passId, competitors);
        return new RaceLogStartTimeEventImpl(event.getCreatedAt(), event.getLogicalTimePoint(), author, event.getId(), event.getPassId(), (TimePoint)new MillisecondsTimePoint(startTime), event.getNextStatus(), courseAreaId);
    }
}

