/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogProtestStartTimeEventImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.BaseRaceLogEventDeserializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.io.Serializable;
import java.util.List;
import org.json.simple.JSONObject;

public class RaceLogProtestStartTimeEventDeserializer
extends BaseRaceLogEventDeserializer {
    public RaceLogProtestStartTimeEventDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer) {
        super(competitorDeserializer);
    }

    @Override
    protected RaceLogEvent deserialize(JSONObject object, Serializable id, TimePoint createdAt, AbstractLogEventAuthor author, TimePoint timePoint, int passId, List<Competitor> competitors) throws JsonDeserializationException {
        Long protestStartMillis = (Long)object.get((Object)"protestStartTime");
        MillisecondsTimePoint protestStart = new MillisecondsTimePoint(protestStartMillis.longValue());
        Long protestEndMillis = (Long)object.get((Object)"protestEndTime");
        Object protestEnd = protestEndMillis == null ? protestStart.plus(Duration.ONE_MINUTE.times(90L)) : new MillisecondsTimePoint(protestEndMillis.longValue());
        TimeRangeImpl protestTime = new TimeRangeImpl((TimePoint)protestStart, protestEnd);
        return new RaceLogProtestStartTimeEventImpl(createdAt, timePoint, author, id, passId, (TimeRange)protestTime);
    }
}

