/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningEvent;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultImpl;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultsImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.BaseRaceLogEventDeserializer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class RaceLogFinishPositioningEventDeserializer
extends BaseRaceLogEventDeserializer {
    public RaceLogFinishPositioningEventDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer) {
        super(competitorDeserializer);
    }

    @Override
    protected RaceLogEvent deserialize(JSONObject object, Serializable id, TimePoint createdAt, AbstractLogEventAuthor author, TimePoint timePoint, int passId, List<Competitor> competitors) throws JsonDeserializationException {
        JSONArray jsonPositionedCompetitors = Helpers.getNestedArraySafe(object, "positionedCompetitors");
        CompetitorResults positionedCompetitors = this.deserializePositionedCompetitors(jsonPositionedCompetitors);
        return this.createRaceLogFinishPositioningEvent(id, createdAt, author, timePoint, passId, positionedCompetitors);
    }

    protected abstract RaceLogFinishPositioningEvent createRaceLogFinishPositioningEvent(Serializable var1, TimePoint var2, AbstractLogEventAuthor var3, TimePoint var4, int var5, CompetitorResults var6);

    private CompetitorResults deserializePositionedCompetitors(JSONArray jsonPositionedCompetitors) throws JsonDeserializationException {
        CompetitorResultsImpl positionedCompetitors = new CompetitorResultsImpl();
        int rankCounter = 1;
        for (Object object : jsonPositionedCompetitors) {
            JSONObject jsonPositionedCompetitor = Helpers.toJSONObjectSafe(object);
            Serializable competitorId = (Serializable)jsonPositionedCompetitor.get((Object)"competitorId");
            competitorId = UUIDHelper.tryUuidConversion((Serializable)competitorId);
            String competitorName = (String)jsonPositionedCompetitor.get((Object)"competitorName");
            String competitorShortName = (String)jsonPositionedCompetitor.get((Object)"competitorShortName");
            String competitorBoatName = (String)jsonPositionedCompetitor.get((Object)"competitorBoatName");
            String competitorBoatSailId = (String)jsonPositionedCompetitor.get((Object)"competitorBoatSailId");
            String maxPointsReasonName = (String)jsonPositionedCompetitor.get((Object)"maxPointsReason");
            MaxPointsReason maxPointsReason = MaxPointsReason.valueOf((String)maxPointsReasonName);
            Number rank = (Number)jsonPositionedCompetitor.get((Object)"rank");
            Double score = (Double)jsonPositionedCompetitor.get((Object)"score");
            Long finishingTimePointAsMillis = (Long)jsonPositionedCompetitor.get((Object)"finishingTimePointAsMillis");
            MillisecondsTimePoint finishingTime = finishingTimePointAsMillis == null ? null : new MillisecondsTimePoint(finishingTimePointAsMillis.longValue());
            String comment = (String)jsonPositionedCompetitor.get((Object)"comment");
            String mergeStateAsString = (String)jsonPositionedCompetitor.get((Object)"mergeState");
            CompetitorResult.MergeState mergeState = mergeStateAsString == null ? CompetitorResult.MergeState.OK : CompetitorResult.MergeState.valueOf((String)mergeStateAsString);
            CompetitorResultImpl positionedCompetitor = new CompetitorResultImpl(competitorId, competitorName, competitorShortName, competitorBoatName, competitorBoatSailId, rank == null ? rankCounter : rank.intValue(), maxPointsReason, score, (TimePoint)finishingTime, comment, mergeState);
            ++rankCounter;
            positionedCompetitors.add((CompetitorResult)positionedCompetitor);
        }
        return positionedCompetitors;
    }
}

