/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogDependentStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.SimpleRaceLogIdentifierImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.RaceLogRaceStatusEventDeserializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.RaceLogDependentStartTimeEventSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.json.simple.JSONObject;

public class RaceLogDependentStartTimeEventDeserializer
extends RaceLogRaceStatusEventDeserializer {
    public RaceLogDependentStartTimeEventDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer) {
        super(competitorDeserializer);
    }

    @Override
    protected RaceLogEvent deserialize(JSONObject object, Serializable id, TimePoint createdAt, AbstractLogEventAuthor author, TimePoint timePoint, int passId, List<Competitor> competitors) throws JsonDeserializationException {
        String raceColumnName = (String)object.get((Object)"dependentOnRaceColumn");
        String regattaLikeParentName = (String)object.get((Object)"dependentOnRegattaLike");
        String fleetName = (String)object.get((Object)"dependentOnFleet");
        long startTimeDifferenceInMs = (Long)object.get((Object)"startTimeDifference");
        MillisecondsDurationImpl startTimeDifference = new MillisecondsDurationImpl(startTimeDifferenceInMs);
        RaceLogRaceStatusEvent event = (RaceLogRaceStatusEvent)super.deserialize(object, id, createdAt, author, timePoint, passId, competitors);
        SimpleRaceLogIdentifierImpl dependentOnRace = new SimpleRaceLogIdentifierImpl(regattaLikeParentName, raceColumnName, fleetName);
        String courseAreaIdAsString = (String)object.get(RaceLogDependentStartTimeEventSerializer.FIELD_COURSE_AREA_ID_AS_STRING);
        UUID courseAreaId = courseAreaIdAsString != null ? UUID.fromString(courseAreaIdAsString) : null;
        return new RaceLogDependentStartTimeEventImpl(event.getCreatedAt(), event.getLogicalTimePoint(), author, event.getId(), event.getPassId(), (SimpleRaceLogIdentifier)dependentOnRace, (Duration)startTimeDifference, event.getNextStatus(), courseAreaId);
    }
}

