/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.orc.FixedSpeedImpliedWind;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.OtherRaceAsImpliedWindSource;
import com.sap.sailing.domain.common.orc.OwnMaxImpliedWind;
import com.sap.sailing.domain.common.orc.impl.FixedSpeedImpliedWindSourceImpl;
import com.sap.sailing.domain.common.orc.impl.OtherRaceAsImpliedWindSourceImpl;
import com.sap.sailing.domain.common.orc.impl.OwnMaxImpliedWindImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class ImpliedWindSourceDeserializer
implements JsonDeserializer<ImpliedWindSource> {
    private static final Logger logger = Logger.getLogger(ImpliedWindSourceDeserializer.class.getName());

    public ImpliedWindSource deserialize(JSONObject object) throws JsonDeserializationException {
        OwnMaxImpliedWindImpl impliedWindSource;
        String type;
        Object typeObject = object.get((Object)"impliedWindSourceType");
        String string = type = typeObject == null ? null : typeObject.toString();
        if (type == null) {
            impliedWindSource = null;
        } else if (type.equals(FixedSpeedImpliedWind.class.getSimpleName())) {
            Number impliedWindSpeedInKnotsAsNumber = (Number)object.get((Object)"impliedWindInKnots");
            KnotSpeedImpl impliedWindSpeed = impliedWindSpeedInKnotsAsNumber == null ? null : new KnotSpeedImpl(impliedWindSpeedInKnotsAsNumber.doubleValue());
            impliedWindSource = new FixedSpeedImpliedWindSourceImpl((Speed)impliedWindSpeed);
        } else if (type.equals(OwnMaxImpliedWind.class.getSimpleName())) {
            impliedWindSource = new OwnMaxImpliedWindImpl();
        } else if (type.equals(OtherRaceAsImpliedWindSource.class.getSimpleName())) {
            impliedWindSource = new OtherRaceAsImpliedWindSourceImpl(new Util.Triple((Object)object.get((Object)"otherRaceRegattaLikeName").toString(), (Object)object.get((Object)"otherRaceRaceColumnName").toString(), (Object)object.get((Object)"otherRaceFleetName").toString()));
        } else {
            logger.log(Level.SEVERE, "Unknown implied wind source type " + type + " while de-serializing race log event " + object);
            impliedWindSource = null;
        }
        return impliedWindSource;
    }
}

