/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racegroup.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sailing.domain.base.racegroup.SeriesWithRows;
import com.sap.sailing.domain.base.racegroup.impl.RaceGroupImpl;
import com.sap.sailing.server.gateway.deserialization.impl.BoatClassJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.ColorDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.FleetDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.PositionJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.TargetTimeInfoDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.WindJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.racegroup.impl.RaceCellDeserializer;
import com.sap.sailing.server.gateway.deserialization.racegroup.impl.RaceRowDeserializer;
import com.sap.sailing.server.gateway.deserialization.racegroup.impl.SeriesWithRowsDeserializer;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.RaceLogDeserializer;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.RaceLogEventDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import org.json.simple.JSONObject;

public class RaceGroupDeserializer
implements JsonDeserializer<RaceGroup> {
    private final JsonDeserializer<BoatClass> boatClassDeserializer;
    private final JsonDeserializer<SeriesWithRows> seriesDeserializer;
    private final JsonDeserializer<RegattaConfiguration> configurationDeserializer;

    public static RaceGroupDeserializer create(SharedDomainFactory<?> domainFactory, JsonDeserializer<RegattaConfiguration> proceduresDeserializer) {
        return new RaceGroupDeserializer(new BoatClassJsonDeserializer(domainFactory), new SeriesWithRowsDeserializer(new RaceRowDeserializer(new FleetDeserializer(new ColorDeserializer()), new RaceCellDeserializer(new RaceLogDeserializer(RaceLogEventDeserializer.create(domainFactory)), new TargetTimeInfoDeserializer(new WindJsonDeserializer(new PositionJsonDeserializer()))))), proceduresDeserializer);
    }

    public RaceGroupDeserializer(JsonDeserializer<BoatClass> boatClassDeserializer, JsonDeserializer<SeriesWithRows> seriesDeserializer, JsonDeserializer<RegattaConfiguration> configurationDeserializer) {
        this.boatClassDeserializer = boatClassDeserializer;
        this.seriesDeserializer = seriesDeserializer;
        this.configurationDeserializer = configurationDeserializer;
    }

    public RaceGroup deserialize(JSONObject object) throws JsonDeserializationException {
        String name = object.get((Object)"name").toString();
        BoatClass boatClass = null;
        String displayName = null;
        Boolean canBoatsOfCompetitorsChangePerRace = false;
        RegattaConfiguration configuration = null;
        if (object.containsKey((Object)"boatClass")) {
            boatClass = (BoatClass)this.boatClassDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "boatClass"));
        }
        ArrayList<SeriesWithRows> series = new ArrayList<SeriesWithRows>();
        for (Object seriesObject : Helpers.getNestedArraySafe(object, "series")) {
            JSONObject seriesJson = Helpers.toJSONObjectSafe(seriesObject);
            series.add((SeriesWithRows)this.seriesDeserializer.deserialize(seriesJson));
        }
        if (object.containsKey((Object)"procedures")) {
            JSONObject value = Helpers.getNestedObjectSafe(object, "procedures");
            configuration = (RegattaConfiguration)this.configurationDeserializer.deserialize(value);
        }
        if (object.containsKey((Object)"displayName")) {
            Object displayNameJson = object.get((Object)"displayName");
            String string = displayName = displayNameJson == null ? null : displayNameJson.toString();
        }
        if (object.containsKey((Object)"canBoatsOfCompetitorsChangePerRace")) {
            Object canBoatsOfCompetitorsChangePerRaceJson = object.get((Object)"canBoatsOfCompetitorsChangePerRace");
            canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRaceJson == null ? null : (Boolean)canBoatsOfCompetitorsChangePerRaceJson;
        }
        return new RaceGroupImpl(name, displayName, boatClass, canBoatsOfCompetitorsChangePerRace.booleanValue(), series, configuration);
    }
}

