/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class WindJsonDeserializer
implements JsonDeserializer<Wind> {
    private JsonDeserializer<Position> positionDeserializer;

    public WindJsonDeserializer(JsonDeserializer<Position> positionDeserializer) {
        this.positionDeserializer = positionDeserializer;
    }

    public Wind deserialize(JSONObject object) throws JsonDeserializationException {
        JSONObject positionJsonObject = Helpers.getNestedObjectSafe(object, "position");
        Position position = positionJsonObject == null ? null : (Position)this.positionDeserializer.deserialize(positionJsonObject);
        Number timeStamp = (Number)object.get((Object)"timepoint");
        Number direction = (Number)object.get((Object)"direction");
        if (direction == null) {
            direction = (Number)object.get((Object)"bearing");
        }
        Number speedInKnots = (Number)object.get((Object)"speedinknots");
        DegreeBearingImpl degreeBearing = new DegreeBearingImpl(direction.doubleValue());
        KnotSpeedWithBearingImpl speedBearing = new KnotSpeedWithBearingImpl(speedInKnots.doubleValue(), (Bearing)degreeBearing);
        WindImpl wind = new WindImpl(position, (TimePoint)new MillisecondsTimePoint(timeStamp.longValue()), (SpeedWithBearing)speedBearing);
        return wind;
    }
}

