/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.impl.VenueImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VenueJsonDeserializer
implements JsonDeserializer<Venue> {
    private JsonDeserializer<CourseArea> courseAreaDeserializer;

    public VenueJsonDeserializer(JsonDeserializer<CourseArea> courseAreaDeserializer) {
        this.courseAreaDeserializer = courseAreaDeserializer;
    }

    public Venue deserialize(JSONObject object) throws JsonDeserializationException {
        String name = (String)object.get((Object)"name");
        VenueImpl venue = new VenueImpl(name);
        JSONArray courseAreaArray = Helpers.getNestedArraySafe(object, "courseAreas");
        for (Object element : courseAreaArray) {
            JSONObject courseAreaObject = Helpers.toJSONObjectSafe(element);
            venue.addCourseArea((CourseArea)this.courseAreaDeserializer.deserialize(courseAreaObject));
        }
        return venue;
    }
}

