/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.domain.statistics.impl.StatisticsImpl;
import com.sap.sailing.server.gateway.deserialization.impl.CompetitorJsonDeserializer;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class StatisticsJsonDeserializer
implements JsonDeserializer<Statistics> {
    private final CompetitorJsonDeserializer competitorJsonDeserializer;

    public static StatisticsJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new StatisticsJsonDeserializer(CompetitorJsonDeserializer.create(baseDomainFactory));
    }

    private StatisticsJsonDeserializer(CompetitorJsonDeserializer competitorJsonDeserializer) {
        this.competitorJsonDeserializer = competitorJsonDeserializer;
    }

    public Statistics deserialize(JSONObject object) throws JsonDeserializationException {
        Util.Triple maxSpeed;
        int competitors = this.getIntValue(object, "numberOfCompetitors");
        int regattas = this.getIntValue(object, "numberOfRegattas");
        int races = this.getIntValue(object, "numberOfRaces");
        int trackedRaces = this.getIntValue(object, "numberOfTrackedRaces");
        long gpsFixes = this.getLongValue(object, "numberOfGPSFixes");
        long windFixes = this.getLongValue(object, "numberOfWindFixes");
        MeterDistance distance = new MeterDistance(this.getDoubleValue(object, "distanceTraveledInMeters"));
        JSONObject maxSpeedObject = (JSONObject)object.get((Object)"maxSpeed");
        if (maxSpeedObject != null) {
            DynamicCompetitor fastestCompetitor = this.competitorJsonDeserializer.deserialize((JSONObject)maxSpeedObject.get((Object)"fastestCompetitor"));
            KnotSpeedImpl fastestCompetitorSpeed = new KnotSpeedImpl(this.getDoubleValue(maxSpeedObject, "fastestCompetitorSpeedInKnots"));
            MillisecondsTimePoint timePoint = new MillisecondsTimePoint(this.getLongValue(maxSpeedObject, "timepointMillis"));
            maxSpeed = new Util.Triple((Object)fastestCompetitor, (Object)fastestCompetitorSpeed, (Object)timePoint);
        } else {
            maxSpeed = null;
        }
        return new StatisticsImpl(competitors, regattas, races, trackedRaces, gpsFixes, windFixes, (Distance)distance, maxSpeed);
    }

    private int getIntValue(JSONObject object, String field) {
        return ((Number)object.get((Object)field)).intValue();
    }

    private long getLongValue(JSONObject object, String field) {
        return ((Number)object.get((Object)field)).longValue();
    }

    private double getDoubleValue(JSONObject object, String field) {
        return ((Number)object.get((Object)field)).doubleValue();
    }
}

