/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import java.util.logging.Logger;

public class UpdateTrackedRaceStatus
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = 5847067037829132465L;
    private static final Logger logger = Logger.getLogger(UpdateTrackedRaceStatus.class.getName());
    private final TrackedRaceStatus newStatus;

    public UpdateTrackedRaceStatus(RegattaAndRaceIdentifier raceIdentifier, TrackedRaceStatus newStatus) {
        super(raceIdentifier);
        this.newStatus = newStatus;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            trackedRace.setStatus(this.newStatus);
        } else {
            logger.warning("Tracked race for " + this.getRaceIdentifier() + " has disappeared");
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

