/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardScoreCorrectionUpdate;
import com.sap.sse.common.TimePoint;

public class UpdateLeaderboardScoreCorrection
extends AbstractLeaderboardScoreCorrectionUpdate {
    private static final long serialVersionUID = 697705655733594367L;
    private final Double correctedScore;

    public UpdateLeaderboardScoreCorrection(String leaderboardName, String columnName, String competitorIdAsString, Double correctedScore, TimePoint timePoint) {
        super(leaderboardName, columnName, competitorIdAsString, timePoint);
        this.correctedScore = correctedScore;
    }

    @Override
    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    @Override
    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    @Override
    protected Double updateScoreCorrection(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn) {
        Double newTotalPoints;
        if (this.correctedScore == null) {
            leaderboard.getScoreCorrection().uncorrectScore(competitor, raceColumn);
            newTotalPoints = leaderboard.getTotalPoints(competitor, raceColumn, this.getTimePoint());
        } else {
            leaderboard.getScoreCorrection().correctScore(competitor, raceColumn, this.correctedScore.doubleValue());
            newTotalPoints = this.correctedScore;
        }
        return newTotalPoints;
    }
}

