/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.ThresholdBasedResultDiscardingRuleImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class UpdateLeaderboard
extends AbstractLeaderboardOperation<Leaderboard> {
    private static final long serialVersionUID = -8040361040050151768L;
    private final String newLeaderboardDisplayName;
    private final int[] newDiscardingThresholds;
    private final Collection<Serializable> newCourseAreaIds;

    public UpdateLeaderboard(String leaderboardName, String newLeaderboardDisplayName, int[] newDiscardingThresholds, Iterable<? extends Serializable> newCourseAreaIds) {
        super(leaderboardName);
        this.newLeaderboardDisplayName = newLeaderboardDisplayName;
        this.newDiscardingThresholds = newDiscardingThresholds;
        this.newCourseAreaIds = new ArrayList<Serializable>();
        Util.addAll(newCourseAreaIds, this.newCourseAreaIds);
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    public Leaderboard internalApplyTo(RacingEventService toState) {
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (!(this.newDiscardingThresholds == null || leaderboard.getResultDiscardingRule() instanceof ThresholdBasedResultDiscardingRule && Arrays.equals(((ThresholdBasedResultDiscardingRule)leaderboard.getResultDiscardingRule()).getDiscardIndexResultsStartingWithHowManyRaces(), this.newDiscardingThresholds))) {
            leaderboard.setCrossLeaderboardResultDiscardingRule((ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(this.newDiscardingThresholds));
        }
        leaderboard.setDisplayName(this.newLeaderboardDisplayName);
        if (leaderboard instanceof FlexibleLeaderboard) {
            FlexibleLeaderboard flexibleLeaderboard = (FlexibleLeaderboard)leaderboard;
            flexibleLeaderboard.setCourseAreas(Util.map(this.newCourseAreaIds, toState::getCourseArea));
        }
        this.updateStoredLeaderboard(toState, leaderboard);
        return leaderboard;
    }
}

