/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;

public class UpdateCompetitorDisplayNameInLeaderboard
extends AbstractLeaderboardOperation<Void> {
    private static final long serialVersionUID = 366335484317671148L;
    private final String competitorIdAsString;
    private final String newDisplayName;

    public UpdateCompetitorDisplayNameInLeaderboard(String leaderboardName, String competitorIdAsString, String newDisplayName) {
        super(leaderboardName);
        this.competitorIdAsString = competitorIdAsString;
        this.newDisplayName = newDisplayName;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    public Void internalApplyTo(RacingEventService toState) {
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        Competitor competitor = leaderboard.getCompetitorByIdAsString(this.competitorIdAsString);
        if (competitor != null) {
            leaderboard.setDisplayName(competitor, this.newDisplayName);
            this.updateStoredLeaderboard(toState, leaderboard);
        }
        return null;
    }
}

