/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;

public class SetSuppressedFlagForCompetitorInLeaderboard
extends AbstractLeaderboardOperation<Void> {
    private static final long serialVersionUID = -6509970065541824854L;
    private final String competitorIdAsString;
    private final boolean suppressed;

    public SetSuppressedFlagForCompetitorInLeaderboard(String leaderboardName, String competitorIdAsString, boolean suppressed) {
        super(leaderboardName);
        this.competitorIdAsString = competitorIdAsString;
        this.suppressed = suppressed;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        Competitor competitor = leaderboard.getCompetitorByIdAsString(this.competitorIdAsString);
        if (competitor != null) {
            leaderboard.setSuppressed(competitor, this.suppressed);
            toState.updateStoredLeaderboard(leaderboard);
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

