/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import java.util.logging.Logger;

public class CreateRegattaLeaderboardWithOtherTieBreakingLeaderboard
extends AbstractLeaderboardOperation<RegattaLeaderboardWithOtherTieBreakingLeaderboard> {
    private static final long serialVersionUID = -2851501773630513795L;
    private static final Logger logger = Logger.getLogger(CreateRegattaLeaderboardWithOtherTieBreakingLeaderboard.class.getName());
    private final RegattaIdentifier regattaIdentifier;
    private final String leaderboardDisplayName;
    private final int[] discardThresholds;
    private final String otherTieBreakingLeaderboardName;

    public CreateRegattaLeaderboardWithOtherTieBreakingLeaderboard(RegattaIdentifier regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds, String otherTieBreakingLeaderboardName) {
        super(((RegattaName)regattaIdentifier).getRegattaName());
        this.regattaIdentifier = regattaIdentifier;
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.discardThresholds = discardThresholds;
        this.otherTieBreakingLeaderboardName = otherTieBreakingLeaderboardName;
    }

    public RegattaLeaderboardWithOtherTieBreakingLeaderboard internalApplyTo(RacingEventService toState) {
        RegattaLeaderboardWithOtherTieBreakingLeaderboard result = null;
        if (toState.getLeaderboardByName(this.getLeaderboardName()) == null) {
            result = toState.addRegattaLeaderboardWithOtherTieBreakingLeaderboard(this.regattaIdentifier, this.leaderboardDisplayName, this.discardThresholds, (RegattaLeaderboard)toState.getLeaderboardByName(this.otherTieBreakingLeaderboardName));
        } else {
            logger.warning("Cannot replicate creation of regatta leaderboard " + this.getLeaderboardName() + " because it already exists in the replica");
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return serverOp.transformAddRegattaLeaderboardClientOp(this);
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return clientOp.transformAddRegattaLeaderboardServerOp(this);
    }
}

