/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import java.util.logging.Logger;

public class CreateRegattaLeaderboardWithEliminations
extends AbstractLeaderboardOperation<RegattaLeaderboard> {
    private static final long serialVersionUID = -2851501773630513795L;
    private static final Logger logger = Logger.getLogger(CreateRegattaLeaderboardWithEliminations.class.getName());
    private final String fullRegattaLeaderboardName;
    private final String leaderboardDisplayName;

    public CreateRegattaLeaderboardWithEliminations(String name, String leaderboardDisplayName, String fullRegattaLeaderboardName) {
        super(name);
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.fullRegattaLeaderboardName = fullRegattaLeaderboardName;
    }

    public RegattaLeaderboard internalApplyTo(RacingEventService toState) {
        RegattaLeaderboardWithEliminations result = null;
        if (toState.getLeaderboardByName(this.getLeaderboardName()) == null) {
            result = toState.addRegattaLeaderboardWithEliminations(this.getLeaderboardName(), this.leaderboardDisplayName, (RegattaLeaderboard)toState.getLeaderboardByName(this.fullRegattaLeaderboardName));
        } else {
            logger.warning("Cannot replicate creation of regatta leaderboard " + this.getLeaderboardName() + " because it already exists in the replica");
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return serverOp.transformAddRegattaLeaderboardClientOp(this);
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return clientOp.transformAddRegattaLeaderboardServerOp(this);
    }
}

