/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;

public class CreateCompetitor
extends AbstractRacingEventServiceOperation<Competitor> {
    private static final long serialVersionUID = 1172181354320184263L;
    private final Serializable competitorId;
    private final String name;
    private final String shortName;
    private final Color displayColor;
    private final String email;
    private final URI flagImageUri;
    private final Nationality nationality;
    private final Double timeOnTimeFactor;
    private final Duration timeOnDistanceAllowancePerNauticalMile;
    private final String searchTag;
    private final Serializable boatId;

    public CreateCompetitor(Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageUri, Nationality nationality, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, Serializable boatId) {
        this.competitorId = competitorId;
        this.name = name;
        this.shortName = shortName;
        this.displayColor = displayColor;
        this.email = email;
        this.flagImageUri = flagImageUri;
        this.nationality = nationality;
        this.timeOnTimeFactor = timeOnTimeFactor;
        this.timeOnDistanceAllowancePerNauticalMile = timeOnDistanceAllowancePerNauticalMile;
        this.searchTag = searchTag;
        this.boatId = boatId;
    }

    public boolean isRequiresExplicitTransitiveReplication() {
        return false;
    }

    public Competitor internalApplyTo(RacingEventService toState) throws Exception {
        DynamicCompetitor result;
        PersonImpl sailor = new PersonImpl(this.name, this.nationality, null, null);
        TeamImpl team = new TeamImpl(String.valueOf(this.name) + " team", Collections.singleton(sailor), null);
        if (this.boatId == null) {
            result = toState.getBaseDomainFactory().getCompetitorAndBoatStore().getOrCreateCompetitor(this.competitorId, this.name, this.shortName, this.displayColor, this.email, this.flagImageUri, (DynamicTeam)team, this.timeOnTimeFactor, this.timeOnDistanceAllowancePerNauticalMile, this.searchTag, true);
        } else {
            DynamicBoat boat = toState.getBaseDomainFactory().getCompetitorAndBoatStore().getExistingBoatById(this.boatId);
            if (boat == null) {
                throw new IllegalStateException("Boat with ID " + this.boatId + " not found");
            }
            result = toState.getBaseDomainFactory().getCompetitorAndBoatStore().getOrCreateCompetitorWithBoat(this.competitorId, this.name, this.shortName, this.displayColor, this.email, this.flagImageUri, (DynamicTeam)team, this.timeOnTimeFactor, this.timeOnDistanceAllowancePerNauticalMile, this.searchTag, boat, true);
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

