/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.Color;
import java.io.Serializable;

public class CreateBoat
extends AbstractRacingEventServiceOperation<Boat> {
    private static final long serialVersionUID = 4868428194661255331L;
    private final Serializable boatId;
    private final String name;
    private final String boatClassName;
    private final Color color;
    private final String sailId;

    public CreateBoat(Serializable boatId, String name, String boatClassName, String sailId, Color color) {
        this.boatId = boatId;
        this.name = name;
        this.boatClassName = boatClassName;
        this.sailId = sailId;
        this.color = color;
    }

    public boolean isRequiresExplicitTransitiveReplication() {
        return false;
    }

    public Boat internalApplyTo(RacingEventService toState) throws Exception {
        BoatClass boatClass = toState.getBaseDomainFactory().getOrCreateBoatClass(this.boatClassName);
        DynamicBoat result = toState.getBaseDomainFactory().getCompetitorAndBoatStore().getOrCreateBoat(this.boatId, this.name, boatClass, this.sailId, this.color, true);
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

