/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.store;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelNotFoundException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.AbstractModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategy;
import com.sap.sailing.windestimation.model.store.PersistableModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryModelStoreImpl
extends AbstractModelStoreImpl {
    private final Map<String, byte[]> serializedModels = new ConcurrentHashMap<String, byte[]>();

    @Override
    public <InstanceType, T extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, T>> ModelType loadModel(ModelType newModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(newModel);
        byte[] serializedModel = this.serializedModels.get(this.getPersistenceKey(newModel));
        if (serializedModel != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayInputStream input = new ByteArrayInputStream(serializedModel);){
                    TrainableModel loadedModel = (TrainableModel)serializationStrategy.deserializeFromStream(input);
                    if (!((ModelContext)newModel.getModelContext()).equals(loadedModel.getModelContext())) {
                        throw new ModelPersistenceException("The configuration of the loaded model is: " + loadedModel.getModelContext() + ". \nExpected: " + newModel.getModelContext());
                    }
                    return (ModelType)loadedModel;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ModelPersistenceException(e);
            }
        }
        throw new ModelNotFoundException((ModelContext<?>)newModel.getModelContext());
    }

    @Override
    public void persistModel(PersistableModel<?, ?> trainedModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(trainedModel);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                serializationStrategy.serializeToStream(trainedModel, output);
                byte[] serializedModel = output.toByteArray();
                this.serializedModels.put(this.getPersistenceKey(trainedModel), serializedModel);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ModelPersistenceException(e);
        }
    }

    public <T extends PersistableModel<?, ?>> void delete(T newModel) throws ModelPersistenceException {
        this.checkAndGetModelSerializationStrategy(newModel);
        this.serializedModels.remove(this.getPersistenceKey(newModel));
    }

    @Override
    public void deleteAll(ModelDomainType domainType) {
        Iterator<String> iterator = this.serializedModels.keySet().iterator();
        while (iterator.hasNext()) {
            String filename = iterator.next();
            if (!filename.endsWith(".clf") || !filename.startsWith(this.getPersistenceKeyPartOfModelDomain(domainType))) continue;
            iterator.remove();
        }
    }

    @Override
    public Map<String, byte[]> exportAllPersistedModels(ModelDomainType domainType) {
        HashMap<String, byte[]> exportedModels = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : this.serializedModels.entrySet()) {
            String fileName = entry.getKey();
            if (!this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) continue;
            exportedModels.put(fileName, entry.getValue());
        }
        return exportedModels;
    }

    @Override
    public void importPersistedModels(Map<String, byte[]> exportedPersistedModels, ModelDomainType domainType) {
        for (Map.Entry<String, byte[]> entry : exportedPersistedModels.entrySet()) {
            String fileName = entry.getKey();
            byte[] exportedModel = entry.getValue();
            this.serializedModels.put(fileName, exportedModel);
        }
    }

    @Override
    public List<PersistableModel<?, ?>> loadAllPersistedModels(ModelDomainType domainType) {
        ArrayList loadedModels = new ArrayList();
        for (Map.Entry<String, byte[]> entry : this.serializedModels.entrySet()) {
            PersistableModel<?, ?> loadedModel;
            String fileName = entry.getKey();
            if (!this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) continue;
            ModelSerializationStrategy serializationStrategy = this.getModelSerializationStrategyFromPersistenceKey(fileName);
            if (serializationStrategy == null) {
                throw new ModelLoadingException("Persistence support could not be determined due to invalid filename pattern: \"" + fileName + "\"");
            }
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (ByteArrayInputStream input = new ByteArrayInputStream(entry.getValue());){
                    loadedModel = serializationStrategy.deserializeFromStream(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ModelLoadingException("Could not read model \"" + fileName + "\" from its serialized in-memory state", e);
            }
            loadedModels.add(loadedModel);
        }
        return loadedModels;
    }
}

