/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.regressor.TrainableRegressorModel;
import com.sap.sailing.windestimation.model.regressor.twdtransition.DistanceBasedTwdTransitionRegressorModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.DistanceBasedTwdTransitionRegressorModelFactory;
import com.sap.sailing.windestimation.model.regressor.twdtransition.DurationBasedTwdTransitionRegressorModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.DurationBasedTwdTransitionRegressorModelFactory;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SingleDimensionBasedTwdTransitionRegressorCache;
import com.sap.sailing.windestimation.model.store.ModelStore;
import smile.stat.distribution.GaussianDistribution;

public class GaussianBasedTwdTransitionDistributionCache {
    private final SingleDimensionBasedTwdTransitionRegressorCache<DurationBasedTwdTransitionRegressorModelContext> durationBasedTwdTransitionRegressorCache;
    private final SingleDimensionBasedTwdTransitionRegressorCache<DistanceBasedTwdTransitionRegressorModelContext> distanceBasedTwdTransitionRegressorCache;
    private final boolean preloadAllModels;

    public GaussianBasedTwdTransitionDistributionCache(ModelStore modelStore, boolean preloadAllModels, long preserveLoadedModelsMillis) {
        this.preloadAllModels = preloadAllModels;
        this.durationBasedTwdTransitionRegressorCache = new SingleDimensionBasedTwdTransitionRegressorCache<DurationBasedTwdTransitionRegressorModelContext>(modelStore, preloadAllModels, preserveLoadedModelsMillis, new DurationBasedTwdTransitionRegressorModelFactory());
        this.distanceBasedTwdTransitionRegressorCache = new SingleDimensionBasedTwdTransitionRegressorCache<DistanceBasedTwdTransitionRegressorModelContext>(modelStore, preloadAllModels, preserveLoadedModelsMillis, new DistanceBasedTwdTransitionRegressorModelFactory());
    }

    public double getCompoundDistance(TwdTransition twdTransition) {
        double durationBasedStd = ((TrainableRegressorModel)this.durationBasedTwdTransitionRegressorCache.getBestModel(twdTransition)).getValue(twdTransition);
        double distanceBasedStd = ((TrainableRegressorModel)this.distanceBasedTwdTransitionRegressorCache.getBestModel(twdTransition)).getValue(twdTransition);
        return durationBasedStd + distanceBasedStd;
    }

    public double getProbability(TwdTransition twdTransition) {
        double stdSum = this.getCompoundDistance(twdTransition);
        double p = this.getGaussianProbability(stdSum, twdTransition.getTwdChange().abs().getDegrees());
        return p;
    }

    public double getGaussianProbability(double std, double x) {
        GaussianDistribution gaussianDistribution = new GaussianDistribution(0.0, std);
        double p = 1.0 - (gaussianDistribution.cdf(x) - gaussianDistribution.cdf(-x));
        return p;
    }

    public void clearCache() {
        this.durationBasedTwdTransitionRegressorCache.clearCache();
        this.distanceBasedTwdTransitionRegressorCache.clearCache();
    }

    public boolean isReady() {
        return this.durationBasedTwdTransitionRegressorCache.isReady() && this.distanceBasedTwdTransitionRegressorCache.isReady();
    }

    public boolean isPreloadAllModels() {
        return this.preloadAllModels;
    }
}

