/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.maneuver;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.model.classifier.AbstractClassifiersCache;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassificationResultMapper;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifierModelContext;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifierModelFactory;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverFeatures;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.model.store.ModelStore;

public class ManeuverClassifiersCache
extends AbstractClassifiersCache<ManeuverForEstimation, ManeuverClassifierModelContext, ManeuverWithProbabilisticTypeClassification> {
    private final ManeuverFeatures maneuverFeatures;

    public ManeuverClassifiersCache(ModelStore modelStore, boolean preloadAllModels, long preserveLoadedModelsMillis, ManeuverFeatures maxManeuverFeatures) {
        super(modelStore, preloadAllModels, preserveLoadedModelsMillis, new ManeuverClassifierModelFactory(), new ManeuverClassificationResultMapper());
        this.maneuverFeatures = maxManeuverFeatures;
    }

    @Override
    public ManeuverClassifierModelContext getModelContext(ManeuverForEstimation maneuver) {
        ManeuverFeatures maneuverFeatures = this.determineFinalManeuverFeatures(maneuver);
        BoatClass boatClass = maneuverFeatures.isPolarsInformation() ? maneuver.getBoatClass() : null;
        ManeuverClassifierModelContext modelContext = new ManeuverClassifierModelContext(maneuverFeatures, boatClass == null ? null : boatClass.getName(), ManeuverClassifierModelFactory.orderedSupportedTargetValues);
        return modelContext;
    }

    private ManeuverFeatures determineFinalManeuverFeatures(ManeuverForEstimation maneuver) {
        boolean polars = this.maneuverFeatures.isPolarsInformation() && maneuver.getDeviationFromOptimalJibeAngleInDegrees() != null && maneuver.getDeviationFromOptimalTackAngleInDegrees() != null;
        boolean marks = this.maneuverFeatures.isMarksInformation() && maneuver.isMarkPassingDataAvailable();
        return new ManeuverFeatures(polars, this.maneuverFeatures.isScaledSpeed(), marks);
    }

    public ManeuverFeatures getManeuverFeatures() {
        return this.maneuverFeatures;
    }
}

