/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategyType;

public abstract class AbstractTrainableModel<InstanceType, MC extends ModelContext<InstanceType>>
implements TrainableModel<InstanceType, MC> {
    private static final long serialVersionUID = 6483063459903792768L;
    private final MC modelContext;
    private boolean trainingFinished = false;
    private double testScore = 0.0;
    private double trainScore = 0.0;
    private long numberOfTrainingInstances;

    public AbstractTrainableModel(MC modelContext) {
        this.modelContext = modelContext;
    }

    @Override
    public boolean isModelReady() {
        return this.trainingFinished;
    }

    @Override
    public double getTestScore() {
        return this.testScore;
    }

    @Override
    public double getTrainScore() {
        return this.trainScore;
    }

    @Override
    public long getNumberOfTrainingInstances() {
        return this.numberOfTrainingInstances;
    }

    @Override
    public void setStatsAfterSuccessfulTraining(double trainScore, double testScore, long numberOfTrainingInstances) {
        this.trainScore = trainScore;
        this.testScore = testScore;
        this.numberOfTrainingInstances = numberOfTrainingInstances;
    }

    @Override
    public void setModelAsReadyAfterSuccessfulTraining() {
        this.trainingFinished = true;
    }

    @Override
    public void resetTrainingStats() {
        this.trainingFinished = false;
        this.testScore = 0.0;
        this.trainScore = 0.0;
        this.numberOfTrainingInstances = 0L;
    }

    @Override
    public MC getModelContext() {
        return this.modelContext;
    }

    @Override
    public ModelSerializationStrategyType getModelSerializationStrategyType() {
        return ModelSerializationStrategyType.SERIALIZATION;
    }
}

