/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.jaxrs.client;

import com.sap.sailing.windestimation.integration.ReplicableWindEstimationFactoryService;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.parser.ParseException;

public class WindEstimationDataClient {
    private static final Logger logger = Logger.getLogger(WindEstimationDataClient.class.getName());
    private static final String RESOURCE = "windestimation/api/windestimation_data";
    private final ReplicableWindEstimationFactoryService windEstimationFactoryService;
    private final String windEstimationDataSourceURL;
    private final Optional<String> windEstimationModelBearerToken;

    public WindEstimationDataClient(String windEstimationDataSourceURL, ReplicableWindEstimationFactoryService windEstimationFactoryService, Optional<String> windEstimationModelBearerToken) {
        this.windEstimationFactoryService = windEstimationFactoryService;
        this.windEstimationDataSourceURL = windEstimationDataSourceURL;
        this.windEstimationModelBearerToken = windEstimationModelBearerToken;
    }

    public void updateWindEstimationModels() throws IOException, ParseException, InterruptedException, ClassNotFoundException {
        try {
            logger.log(Level.INFO, "Loading model data of wind estimation from remote server " + this.windEstimationDataSourceURL);
            InputStream inputStream = this.getContentFromResponse();
            this.windEstimationFactoryService.clearReplicaState();
            this.windEstimationFactoryService.initiallyFillFrom(inputStream);
            logger.log(Level.INFO, "Loading model data of wind estimation from remote server " + this.windEstimationDataSourceURL + " succeeded");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load model data of wind estimation from remote server " + this.windEstimationDataSourceURL + ", " + e.getMessage());
            this.windEstimationFactoryService.clearReplicaState();
        }
    }

    private String getAPIString() {
        return String.valueOf(this.windEstimationDataSourceURL) + (this.windEstimationDataSourceURL.endsWith("/") ? "" : "/") + RESOURCE;
    }

    protected InputStream getContentFromResponse() throws IOException, ParseException {
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        HttpGet getProcessor = new HttpGet(this.getAPIString());
        this.windEstimationModelBearerToken.ifPresent(bearerToken -> getProcessor.setHeader("Authorization", "Bearer " + bearerToken));
        HttpResponse processorResponse = client.execute((HttpUriRequest)getProcessor);
        if (processorResponse.getStatusLine().getStatusCode() >= 300) {
            throw new IOException("Error trying to load wind estimation data from " + this.getAPIString() + ": " + processorResponse.getStatusLine().getReasonPhrase() + " (" + processorResponse.getStatusLine().getStatusCode() + ")");
        }
        return processorResponse.getEntity().getContent();
    }
}

