/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.jaxrs.api;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.windestimation.integration.ExportedModels;
import com.sap.sailing.windestimation.integration.WindEstimationModelsUpdateOperation;
import com.sap.sailing.windestimation.jaxrs.AbstractWindEstimationDataResource;
import com.sap.sse.ServerInfo;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

@Path(value="/windestimation_data")
public class WindEstimationDataResource
extends AbstractWindEstimationDataResource {
    private static final Logger logger = Logger.getLogger(WindEstimationDataResource.class.getName());

    @GET
    @Produces(value={"application/octet-stream;charset=UTF-8"})
    public Response getInternalModelData() throws IOException {
        Subject subject = SecurityUtils.getSubject();
        logger.info("Wind Estimation Model Data requested by " + (subject.getPrincipal() == null ? "anonymous user" : subject.getPrincipal().toString()));
        subject.checkPermission(SecuredDomainType.WIND_ESTIMATION_MODELS.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                WindEstimationDataResource.this.getWindEstimationFactoryServiceImpl().serializeForInitialReplication(output);
            }
        }).header("Content-Type", (Object)"application/octet-stream").build();
    }

    @POST
    @Produces(value={"text/plain"})
    public Response postInternalModelData(InputStream inputStream) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        logger.info("Wind Estimation Model Data Update requested by " + (subject.getPrincipal() == null ? "anonymous user" : subject.getPrincipal().toString()));
        subject.checkPermission(SecuredDomainType.WIND_ESTIMATION_MODELS.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        ObjectInputStream ois = this.getWindEstimationFactoryServiceImpl().createObjectInputStreamResolvingAgainstCache(inputStream, new HashMap());
        ExportedModels exportedModels = (ExportedModels)ois.readObject();
        WindEstimationModelsUpdateOperation windEstimationModelsUpdateOperation = new WindEstimationModelsUpdateOperation(exportedModels);
        this.getWindEstimationFactoryServiceImpl().apply(windEstimationModelsUpdateOperation);
        logger.info("Wind Estimation Model Data Update requested by " + (subject.getPrincipal() == null ? "anonymous user" : subject.getPrincipal().toString()) + " has completed.");
        return Response.ok((Object)"Wind estimation models accepted").build();
    }
}

