/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.transformer.ManeuverForEstimationTransformer;
import com.sap.sailing.windestimation.integration.ConvertableManeuverForEstimationAdapterForCompleteManeuverCurve;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;

public class CompleteManeuverCurveToManeuverForEstimationConverter {
    private static final Duration MIN_DURATION_TO_OTHER_MANEUVER = new MillisecondsDurationImpl(4000L);
    private final TrackedRace trackedRace;
    private final ManeuverForEstimationTransformer maneuverForEstimationTransformer = new ManeuverForEstimationTransformer();
    private final PolarDataService polarService;

    public CompleteManeuverCurveToManeuverForEstimationConverter(TrackedRace trackedRace, PolarDataService polarService) {
        this.trackedRace = trackedRace;
        this.polarService = polarService;
    }

    public ManeuverForEstimation convertCleanManeuverSpotToManeuverForEstimation(CompleteManeuverCurve maneuver, CompleteManeuverCurve previousManeuver, CompleteManeuverCurve nextManeuver, Competitor competitor, TrackTimeInfo trackTimeInfo) {
        if (!this.maneuverForEstimationTransformer.isManeuverEligibleForAnalysis(maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getDirectionChangeInDegrees(), maneuver.getMainCurveBoundaries().getDirectionChangeInDegrees())) {
            return null;
        }
        BoatClass boatClass = this.trackedRace.getBoatOfCompetitor(competitor).getBoatClass();
        ManeuverCurveBoundaries maneuverCurveBoundaries = maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries();
        GPSFixTrack track = this.trackedRace.getTrack(competitor);
        Position maneuverPosition = track.getEstimatedPosition(maneuver.getTimePoint(), false);
        Double courseChangeInDegreesWithinTurningSectionOfPreviousManeuver = previousManeuver == null ? null : Double.valueOf(previousManeuver.getMainCurveBoundaries().getDirectionChangeInDegrees());
        Double courseChangeInDegreesWithinTurningSectionOfNextManeuver = nextManeuver == null ? null : Double.valueOf(nextManeuver.getMainCurveBoundaries().getDirectionChangeInDegrees());
        Double targetTackAngleInDegrees = this.getTargetTackAngleInDegrees(maneuverCurveBoundaries, boatClass);
        Double targetJibeAngleInDegrees = this.getTargetJibeAngleInDegrees(maneuverCurveBoundaries, boatClass);
        boolean markPassingDataAvailable = maneuver.isMarkPassing() || this.hasNextWaypoint(competitor, maneuverCurveBoundaries.getTimePointAfter());
        Duration durationFromPreviousManeuverEndToManeuverStart = previousManeuver == null ? trackTimeInfo.getTrackStartTimePoint().until(maneuverCurveBoundaries.getTimePointBefore()) : previousManeuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter().until(maneuverCurveBoundaries.getTimePointBefore());
        Duration durationFromManeuverEndToNextManeuverStart = nextManeuver == null ? MIN_DURATION_TO_OTHER_MANEUVER : maneuverCurveBoundaries.getTimePointAfter().until(nextManeuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore());
        MillisecondsDurationImpl longestIntervalBetweenTwoFixes = null;
        Duration intervalBetweenFirstFixOfCurveAndPreviousFix = Duration.ONE_YEAR;
        GPSFixMoving lastFixBeforeManeuver = (GPSFixMoving)track.getLastFixBefore(maneuverCurveBoundaries.getTimePointBefore());
        if (lastFixBeforeManeuver != null) {
            intervalBetweenFirstFixOfCurveAndPreviousFix = lastFixBeforeManeuver.getTimePoint().until(maneuverCurveBoundaries.getTimePointBefore());
        }
        Duration intervalBetweenLastFixOfCurveAndNextFix = Duration.ONE_YEAR;
        GPSFixMoving firstFixAfterManeuver = (GPSFixMoving)track.getFirstFixAfter(maneuverCurveBoundaries.getTimePointAfter());
        if (firstFixAfterManeuver != null) {
            intervalBetweenLastFixOfCurveAndNextFix = maneuverCurveBoundaries.getTimePointAfter().until(firstFixAfterManeuver.getTimePoint());
        }
        GPSFixMoving previousFix = null;
        long longestIntervalBetweenTwoFixesInMillis = 0L;
        track.lockForRead();
        try {
            for (GPSFixMoving fix : track.getFixes(maneuverCurveBoundaries.getTimePointBefore(), true, maneuverCurveBoundaries.getTimePointAfter(), true)) {
                long intervalBetweenPreviousAndCurrentFixInMillis;
                if (previousFix != null && longestIntervalBetweenTwoFixesInMillis < (intervalBetweenPreviousAndCurrentFixInMillis = previousFix.getTimePoint().until(fix.getTimePoint()).asMillis())) {
                    longestIntervalBetweenTwoFixesInMillis = intervalBetweenPreviousAndCurrentFixInMillis;
                }
                previousFix = fix;
            }
        }
        finally {
            track.unlockAfterRead();
        }
        longestIntervalBetweenTwoFixes = new MillisecondsDurationImpl(longestIntervalBetweenTwoFixesInMillis);
        ConvertableManeuverForEstimationAdapterForCompleteManeuverCurve convertableManeuver = new ConvertableManeuverForEstimationAdapterForCompleteManeuverCurve(maneuver, maneuverPosition, markPassingDataAvailable, (Duration)longestIntervalBetweenTwoFixes, courseChangeInDegreesWithinTurningSectionOfPreviousManeuver, courseChangeInDegreesWithinTurningSectionOfNextManeuver, intervalBetweenFirstFixOfCurveAndPreviousFix, intervalBetweenLastFixOfCurveAndNextFix, durationFromPreviousManeuverEndToManeuverStart, durationFromManeuverEndToNextManeuverStart, targetTackAngleInDegrees, targetJibeAngleInDegrees);
        ManeuverForEstimation maneuverForEstimation = this.maneuverForEstimationTransformer.getManeuverForEstimation(convertableManeuver, 1.0, boatClass);
        return maneuverForEstimation;
    }

    private Double getTargetTackAngleInDegrees(ManeuverCurveBoundaries curveWithUnstableCourseAndSpeed, BoatClass boatClass) {
        SpeedWithBearingWithConfidence closestTackTwa;
        SpeedWithBearing boatSpeed;
        Double targetTackAngle = null;
        SpeedWithBearing speedWithBearing = boatSpeed = curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore().compareTo((Object)curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter()) < 0 ? curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore() : curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter();
        if (this.polarService != null && this.polarService.getAllBoatClassesWithPolarSheetsAvailable().contains(boatClass) && (closestTackTwa = this.polarService.getClosestTwaTws(ManeuverType.TACK, (Speed)boatSpeed, curveWithUnstableCourseAndSpeed.getDirectionChangeInDegrees(), boatClass)) != null) {
            targetTackAngle = this.polarService.getManeuverAngleInDegreesFromTwa(ManeuverType.TACK, closestTackTwa.getObject().getBearing());
        }
        return targetTackAngle;
    }

    private boolean hasNextWaypoint(Competitor competitor, TimePoint timePoint) {
        TrackedLegOfCompetitor legAfter = this.trackedRace.getTrackedLeg(competitor, timePoint);
        return legAfter != null && legAfter.getLeg().getTo() != null;
    }

    private Double getTargetJibeAngleInDegrees(ManeuverCurveBoundaries curveWithUnstableCourseAndSpeed, BoatClass boatClass) {
        SpeedWithBearingWithConfidence closestJibeTwa;
        SpeedWithBearing boatSpeed;
        Double targetJibeAngle = null;
        SpeedWithBearing speedWithBearing = boatSpeed = curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore().compareTo((Object)curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter()) < 0 ? curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore() : curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter();
        if (this.polarService != null && this.polarService.getAllBoatClassesWithPolarSheetsAvailable().contains(boatClass) && (closestJibeTwa = this.polarService.getClosestTwaTws(ManeuverType.JIBE, (Speed)boatSpeed, curveWithUnstableCourseAndSpeed.getDirectionChangeInDegrees(), boatClass)) != null) {
            targetJibeAngle = this.polarService.getManeuverAngleInDegreesFromTwa(ManeuverType.JIBE, closestJibeTwa.getObject().getBearing());
        }
        return targetJibeAngle;
    }
}

