/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.data.transformer;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.ManeuverCategory;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.transformer.CompetitorTrackTransformer;
import com.sap.sailing.windestimation.data.transformer.ConvertableToManeuverForEstimation;
import java.util.ArrayList;
import java.util.List;
import smile.sort.QuickSelect;

public class ManeuverForEstimationTransformer
implements CompetitorTrackTransformer<ConvertableToManeuverForEstimation, ManeuverForEstimation> {
    public static final int MIN_SECONDS_TO_OTHER_MANEUVER = 4;

    public List<ManeuverForEstimation> getManeuversForEstimation(List<? extends ConvertableToManeuverForEstimation> convertableManeuvers, BoatClass boatClass) {
        double speedScalingDivisor = this.getSpeedScalingDivisor(convertableManeuvers);
        ArrayList<ManeuverForEstimation> maneuversForEstimation = new ArrayList<ManeuverForEstimation>();
        for (ConvertableToManeuverForEstimation convertableToManeuverForEstimation : convertableManeuvers) {
            ManeuverForEstimation maneuverForEstimation = this.getManeuverForEstimation(convertableToManeuverForEstimation, speedScalingDivisor, boatClass);
            maneuversForEstimation.add(maneuverForEstimation);
        }
        return maneuversForEstimation;
    }

    public double getSpeedScalingDivisor(List<? extends ConvertableToManeuverForEstimation> competitorTrackManeuvers) {
        ArrayList<Double> speedsInKnotsOfCleanSailingSegments = new ArrayList<Double>();
        ConvertableToManeuverForEstimation previousManeuver = null;
        ConvertableToManeuverForEstimation maneuver = null;
        for (ConvertableToManeuverForEstimation convertableToManeuverForEstimation : competitorTrackManeuvers) {
            if (maneuver != null) {
                if (previousManeuver != null && this.isSegmentBetweenManeuversEligibleForPolarsCollection(previousManeuver, maneuver)) {
                    speedsInKnotsOfCleanSailingSegments.add(maneuver.getSpeedWithBearingBefore().getKnots());
                }
                if (this.isSegmentBetweenManeuversEligibleForPolarsCollection(maneuver, convertableToManeuverForEstimation)) {
                    speedsInKnotsOfCleanSailingSegments.add(maneuver.getSpeedWithBearingAfter().getKnots());
                }
            }
            previousManeuver = maneuver;
            maneuver = convertableToManeuverForEstimation;
        }
        if (maneuver != null) {
            if (this.isSegmentBetweenManeuversEligibleForPolarsCollection(previousManeuver, maneuver)) {
                speedsInKnotsOfCleanSailingSegments.add(maneuver.getSpeedWithBearingBefore().getKnots());
            }
            if (this.isSegmentBetweenManeuversEligibleForPolarsCollection(maneuver, null)) {
                speedsInKnotsOfCleanSailingSegments.add(maneuver.getSpeedWithBearingAfter().getKnots());
            }
        }
        double[] dArray = new double[speedsInKnotsOfCleanSailingSegments.size()];
        int i = 0;
        for (Double speed : speedsInKnotsOfCleanSailingSegments) {
            dArray[i++] = speed;
        }
        if (dArray.length > 0) {
            double scalingDivisor = QuickSelect.select((double[])dArray, (int)((int)((double)dArray.length * 0.98)));
            return scalingDivisor;
        }
        return 10.0;
    }

    public boolean isSegmentBetweenManeuversEligibleForPolarsCollection(ConvertableToManeuverForEstimation fromManeuver, ConvertableToManeuverForEstimation toManeuver) {
        if (fromManeuver == null || toManeuver == null) {
            if (fromManeuver == toManeuver) {
                return false;
            }
            if (fromManeuver == null) {
                return this.isManeuverBoundariesDataClean(toManeuver, true, false);
            }
        }
        return this.isManeuverBoundariesDataClean(fromManeuver, false, true);
    }

    public boolean isManeuverBoundariesDataClean(ConvertableToManeuverForEstimation maneuver, boolean validateManeuverEntering, boolean validateManeuverExiting) {
        return maneuver.getLongestIntervalBetweenTwoFixes().asSeconds() <= 4.0 && (!validateManeuverEntering || maneuver.getIntervalBetweenFirstFixOfCurveAndPreviousFix().asSeconds() <= 4.0) && (!validateManeuverExiting || maneuver.getIntervalBetweenLastFixOfCurveAndNextFix().asSeconds() <= 4.0) && (!validateManeuverEntering || maneuver.getSpeedWithBearingBefore().getKnots() > 2.0) && (!validateManeuverExiting || maneuver.getSpeedWithBearingAfter().getKnots() > 2.0) && (!validateManeuverEntering || maneuver.getDurationFromPreviousManeuverEndToManeuverStart().asSeconds() >= 4.0 || maneuver.getCourseChangeInDegreesWithinTurningSectionOfPreviousManeuver() != null && Math.abs(maneuver.getCourseChangeInDegreesWithinTurningSectionOfPreviousManeuver()) < Math.abs(maneuver.getCourseChangeInDegreesWithinTurningSection()) * 0.3) && (!validateManeuverExiting || maneuver.getDurationFromManeuverEndToNextManeuverStart().asSeconds() >= 4.0 || maneuver.getCourseChangeInDegreesWithinTurningSectionOfNextManeuver() != null && Math.abs(maneuver.getCourseChangeInDegreesWithinTurningSectionOfNextManeuver()) < Math.abs(maneuver.getCourseChangeInDegreesWithinTurningSection()) * 0.3);
    }

    public boolean isManeuverClean(ConvertableToManeuverForEstimation maneuver) {
        return this.isManeuverEligibleForAnalysis(maneuver.getCourseChangeInDegrees(), maneuver.getCourseChangeInDegreesWithinTurningSection()) && this.isManeuverBoundariesDataClean(maneuver, true, true) && Math.abs(maneuver.getSpeedWithBearingBefore().getKnots() - maneuver.getSpeedWithBearingAfter().getKnots()) * 3.0 < Math.min(maneuver.getSpeedWithBearingBefore().getKnots(), maneuver.getSpeedWithBearingAfter().getKnots()) && Math.abs(maneuver.getCourseChangeInDegreesWithinTurningSection() - maneuver.getCourseChangeInDegrees()) < Math.min(Math.abs(maneuver.getCourseChangeInDegrees()) / 2.0, 40.0);
    }

    public ManeuverCategory getManeuverCategory(ConvertableToManeuverForEstimation maneuver) {
        return this.getManeuverCategory(maneuver.getCourseChangeInDegreesWithinTurningSection(), maneuver.isMarkPassing());
    }

    public boolean isManeuverEligibleForAnalysis(double courseChangeInDegrees, double courseChangeWithinTurningSectionInDegrees) {
        return this.getManeuverCategory(courseChangeWithinTurningSectionInDegrees, false) == ManeuverCategory.REGULAR && this.getManeuverCategory(courseChangeInDegrees, false) == ManeuverCategory.REGULAR;
    }

    public ManeuverCategory getManeuverCategory(double courseChangeWithinTurningSectionInDegrees, boolean markPassing) {
        double absCourseChangeInDegrees = Math.abs(courseChangeWithinTurningSectionInDegrees);
        if (absCourseChangeInDegrees < 30.0) {
            return ManeuverCategory.SMALL;
        }
        if (absCourseChangeInDegrees <= 120.0) {
            return markPassing ? ManeuverCategory.MARK_PASSING : ManeuverCategory.REGULAR;
        }
        if (absCourseChangeInDegrees <= 150.0) {
            return ManeuverCategory.WIDE;
        }
        if (absCourseChangeInDegrees <= 310.0) {
            return ManeuverCategory._180;
        }
        return ManeuverCategory._360;
    }

    public ManeuverForEstimation getManeuverForEstimation(ConvertableToManeuverForEstimation maneuver, double speedScalingDivisor, BoatClass boatClass) {
        ManeuverCategory maneuverCategory = this.getManeuverCategory(maneuver);
        double speedLossRatio = maneuver.getSpeedWithBearingBefore().getKnots() > 0.0 ? maneuver.getLowestSpeed().getKnots() / maneuver.getSpeedWithBearingBefore().getKnots() : 0.0;
        double speedGainRatio = maneuver.getHighestSpeedWithinTurningSection().getKnots() > 0.0 ? maneuver.getSpeedWithBearingBeforeWithinTurningSection().getKnots() / maneuver.getHighestSpeedWithinTurningSection().getKnots() : 0.0;
        double lowestSpeedVsExitingSpeedRatio = maneuver.getSpeedWithBearingAfter().getKnots() > 0.0 ? maneuver.getLowestSpeed().getKnots() / maneuver.getSpeedWithBearingAfter().getKnots() : 0.0;
        Double deviationFromOptimalTackAngleInDegrees = maneuver.getTargetTackAngleInDegrees() == null ? null : Double.valueOf(Math.abs(maneuver.getCourseChangeInDegrees()) - maneuver.getTargetTackAngleInDegrees());
        Double deviationFromOptimalJibeAngleInDegrees = maneuver.getTargetJibeAngleInDegrees() == null ? null : Double.valueOf(Math.abs(maneuver.getCourseChangeInDegrees()) - maneuver.getTargetJibeAngleInDegrees());
        boolean clean = this.isManeuverClean(maneuver);
        double scaledSpeedBeforeInKnots = maneuver.getSpeedWithBearingBefore().getKnots() / speedScalingDivisor;
        double scaledSpeedAfterInKnots = maneuver.getSpeedWithBearingAfter().getKnots() / speedScalingDivisor;
        boolean markPassingDataAvailable = maneuver.hasMarkPassingData();
        ManeuverForEstimation maneuverForEstimation = new ManeuverForEstimation(maneuver.getTimePoint(), maneuver.getPosition(), maneuver.getMiddleCourse(), maneuver.getSpeedWithBearingBefore(), maneuver.getSpeedWithBearingAfter(), maneuver.getCourseChangeInDegrees(), maneuver.getCourseChangeInDegreesWithinTurningSection(), maneuver.getMaxTurningRateInDegreesPerSecond(), deviationFromOptimalTackAngleInDegrees, deviationFromOptimalJibeAngleInDegrees, speedLossRatio, speedGainRatio, lowestSpeedVsExitingSpeedRatio, clean, maneuverCategory, scaledSpeedBeforeInKnots, scaledSpeedAfterInKnots, maneuver.isMarkPassing(), boatClass, markPassingDataAvailable);
        return maneuverForEstimation;
    }

    @Override
    public List<ManeuverForEstimation> transformElements(CompetitorTrackWithEstimationData<ConvertableToManeuverForEstimation> competitorTrackWithElementsToTransform) {
        return this.getManeuversForEstimation(competitorTrackWithElementsToTransform.getElements(), competitorTrackWithElementsToTransform.getBoatClass());
    }
}

