/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.polarsfitting;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.windestimation.aggregator.polarsfitting.FineGrainedPointOfSail;
import java.util.Collection;
import java.util.HashSet;

public enum CoarseGrainedPointOfSail {
    UPWIND_STARBOARD,
    REACHING_STARBOARD,
    DOWNWIND_STARBOARD,
    DOWNWIND_PORT,
    REACHING_PORT,
    UPWIND_PORT;


    public LegType getLegType() {
        switch (this) {
            case DOWNWIND_STARBOARD: 
            case DOWNWIND_PORT: {
                return LegType.DOWNWIND;
            }
            case UPWIND_STARBOARD: 
            case UPWIND_PORT: {
                return LegType.UPWIND;
            }
            case REACHING_STARBOARD: 
            case REACHING_PORT: {
                return LegType.REACHING;
            }
        }
        return null;
    }

    public Tack getTack() {
        switch (this) {
            case UPWIND_STARBOARD: 
            case REACHING_STARBOARD: 
            case DOWNWIND_STARBOARD: {
                return Tack.STARBOARD;
            }
            case DOWNWIND_PORT: 
            case REACHING_PORT: 
            case UPWIND_PORT: {
                return Tack.PORT;
            }
        }
        return null;
    }

    public Collection<CoarseGrainedPointOfSail> getNextPossiblePointOfSails(double degreesToAdd) {
        HashSet<CoarseGrainedPointOfSail> result = new HashSet<CoarseGrainedPointOfSail>();
        FineGrainedPointOfSail[] fineGrainedPointOfSailArray = FineGrainedPointOfSail.values();
        int n = fineGrainedPointOfSailArray.length;
        int n2 = 0;
        while (n2 < n) {
            FineGrainedPointOfSail fineGrainedPointOfSail = fineGrainedPointOfSailArray[n2];
            if (fineGrainedPointOfSail.getCoarseGrainedPointOfSail() == this) {
                CoarseGrainedPointOfSail coarseGrainedPointOfSail = fineGrainedPointOfSail.getNextPointOfSail(degreesToAdd).getCoarseGrainedPointOfSail();
                result.add(coarseGrainedPointOfSail);
            }
            ++n2;
        }
        return result;
    }
}

