/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelInference;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestPathsCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.aggregator.msthmm.MstManeuverGraphGenerator;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MstManeuverGraph
implements ManeuverClassificationsAggregator {
    private final MstBestPathsCalculator bestPathsCalculator;

    public MstManeuverGraph(MstBestPathsCalculator bestPathsCalculator) {
        this.bestPathsCalculator = bestPathsCalculator;
    }

    @Override
    public List<ManeuverWithEstimatedType> aggregateManeuverClassifications(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications) {
        List sortedManeuverClassifications = raceWithManeuverClassifications.getCompetitorTracks().stream().flatMap(competitorTrack -> competitorTrack.getElements().stream()).sorted((one, two) -> one.getManeuver().getManeuverTimePoint().compareTo((Object)two.getManeuver().getManeuverTimePoint())).collect(Collectors.toList());
        if (sortedManeuverClassifications.isEmpty()) {
            return Collections.emptyList();
        }
        MstManeuverGraphGenerator graphGenerator = new MstManeuverGraphGenerator(this.bestPathsCalculator.getTransitionProbabilitiesCalculator());
        for (ManeuverWithProbabilisticTypeClassification maneuverClassification : sortedManeuverClassifications) {
            graphGenerator.addNode(maneuverClassification);
        }
        MstManeuverGraphGenerator.MstManeuverGraphComponents graphComponents = graphGenerator.parseGraph();
        ArrayList<ManeuverWithEstimatedType> maneuversWithEstimatedType = new ArrayList<ManeuverWithEstimatedType>();
        Iterable<GraphLevelInference<MstGraphLevel>> bestPath = this.bestPathsCalculator.getBestNodes(graphComponents);
        for (GraphLevelInference<MstGraphLevel> inference : bestPath) {
            ManeuverWithEstimatedType maneuverWithEstimatedType = new ManeuverWithEstimatedType(inference.getGraphLevel().getManeuver(), inference.getGraphNode().getManeuverType(), inference.getConfidence());
            maneuversWithEstimatedType.add(maneuverWithEstimatedType);
        }
        Collections.sort(maneuversWithEstimatedType);
        return maneuversWithEstimatedType;
    }
}

