/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;

public class WindCourseRange {
    private final double fromPortside;
    private final double angleTowardStarboard;

    public WindCourseRange(double fromPortside, double angleTowardStarboard) {
        this.fromPortside = fromPortside;
        this.angleTowardStarboard = angleTowardStarboard;
    }

    public double getFromPortside() {
        return this.fromPortside;
    }

    public double getAngleTowardStarboard() {
        return this.angleTowardStarboard;
    }

    public WindCourseRange invert() {
        double newFromPortside = this.fromPortside + this.angleTowardStarboard;
        if (newFromPortside >= 360.0) {
            newFromPortside -= 360.0;
        }
        double newAngleTowardStarboard = 360.0 - this.angleTowardStarboard;
        return new WindCourseRange(newFromPortside, newAngleTowardStarboard);
    }

    public IntersectedWindRange toIntersected() {
        return new IntersectedWindRange(this.fromPortside, this.angleTowardStarboard, 0.0);
    }

    public IntersectedWindRange intersect(WindCourseRange nextWindRange, CombinationModeOnViolation combinationModeOnViolation) {
        double deviationFromPortsideBoundaryTowardStarboard = nextWindRange.fromPortside - this.fromPortside;
        if (deviationFromPortsideBoundaryTowardStarboard < 0.0) {
            deviationFromPortsideBoundaryTowardStarboard += 360.0;
        }
        double deviationFromPortsideTowardStarboardInDegrees = deviationFromPortsideBoundaryTowardStarboard - this.angleTowardStarboard;
        double newFromPortside = nextWindRange.fromPortside;
        double newAngleTowardStarboard = nextWindRange.angleTowardStarboard;
        double violationRange = 0.0;
        if (deviationFromPortsideTowardStarboardInDegrees <= 0.0) {
            switch (combinationModeOnViolation) {
                case INTERSECTION: {
                    newFromPortside = nextWindRange.fromPortside;
                    if (deviationFromPortsideTowardStarboardInDegrees + nextWindRange.angleTowardStarboard < 0.0) {
                        newAngleTowardStarboard = nextWindRange.angleTowardStarboard;
                        break;
                    }
                    newAngleTowardStarboard = Math.abs(deviationFromPortsideTowardStarboardInDegrees);
                    break;
                }
                case EXPANSION: {
                    newFromPortside = this.fromPortside;
                    newAngleTowardStarboard = this.angleTowardStarboard + deviationFromPortsideTowardStarboardInDegrees + nextWindRange.angleTowardStarboard;
                    break;
                }
            }
        } else {
            double deviationFromPortsideBoundaryTowardPortside = 360.0 - deviationFromPortsideBoundaryTowardStarboard;
            double deviationFromPortsideTowardPortsideInDegrees = deviationFromPortsideBoundaryTowardPortside - nextWindRange.angleTowardStarboard;
            if (deviationFromPortsideTowardPortsideInDegrees <= 0.0) {
                switch (combinationModeOnViolation) {
                    case INTERSECTION: {
                        newFromPortside = this.fromPortside;
                        if (deviationFromPortsideTowardPortsideInDegrees + this.angleTowardStarboard < 0.0) {
                            newAngleTowardStarboard = this.angleTowardStarboard;
                            break;
                        }
                        newAngleTowardStarboard = Math.abs(deviationFromPortsideTowardPortsideInDegrees);
                        break;
                    }
                    case EXPANSION: {
                        newFromPortside = nextWindRange.fromPortside;
                        newAngleTowardStarboard = this.angleTowardStarboard + deviationFromPortsideTowardPortsideInDegrees + nextWindRange.angleTowardStarboard;
                        break;
                    }
                }
            } else {
                if (deviationFromPortsideTowardStarboardInDegrees < deviationFromPortsideTowardPortsideInDegrees) {
                    switch (combinationModeOnViolation) {
                        case INTERSECTION: {
                            newFromPortside = this.fromPortside + this.angleTowardStarboard;
                            newAngleTowardStarboard = deviationFromPortsideTowardStarboardInDegrees;
                            break;
                        }
                        case EXPANSION: {
                            newFromPortside = this.fromPortside;
                            newAngleTowardStarboard = this.angleTowardStarboard + deviationFromPortsideTowardStarboardInDegrees + nextWindRange.angleTowardStarboard;
                        }
                    }
                    violationRange = deviationFromPortsideTowardStarboardInDegrees;
                } else {
                    switch (combinationModeOnViolation) {
                        case INTERSECTION: {
                            newFromPortside = nextWindRange.fromPortside + nextWindRange.angleTowardStarboard;
                            newAngleTowardStarboard = deviationFromPortsideTowardPortsideInDegrees;
                            break;
                        }
                        case EXPANSION: {
                            newFromPortside = nextWindRange.fromPortside;
                            newAngleTowardStarboard = this.angleTowardStarboard + deviationFromPortsideTowardPortsideInDegrees + nextWindRange.angleTowardStarboard;
                        }
                    }
                    violationRange = deviationFromPortsideTowardPortsideInDegrees;
                }
                if (newFromPortside >= 360.0) {
                    newFromPortside -= 360.0;
                }
            }
        }
        if (combinationModeOnViolation == CombinationModeOnViolation.EXPANSION && this instanceof IntersectedWindRange) {
            violationRange += ((IntersectedWindRange)this).getViolationRange();
        }
        return new IntersectedWindRange(newFromPortside, newAngleTowardStarboard, violationRange);
    }

    public boolean isWindCourseWithinRange(double windCourseInDegrees) {
        double deviationFromPortsideTowardStarboardInDegrees;
        double deviationFromPortsideBoundaryTowardStarboard = windCourseInDegrees - this.fromPortside;
        if (deviationFromPortsideBoundaryTowardStarboard < 0.0) {
            deviationFromPortsideBoundaryTowardStarboard += 360.0;
        }
        return (deviationFromPortsideTowardStarboardInDegrees = deviationFromPortsideBoundaryTowardStarboard - this.angleTowardStarboard) <= 0.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.angleTowardStarboard);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.fromPortside);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindCourseRange other = (WindCourseRange)obj;
        if (Double.doubleToLongBits(this.angleTowardStarboard) != Double.doubleToLongBits(other.angleTowardStarboard)) {
            return false;
        }
        return Double.doubleToLongBits(this.fromPortside) == Double.doubleToLongBits(other.fromPortside);
    }

    public String toString() {
        double b;
        double a = 180.0 + this.fromPortside;
        if (a > 360.0) {
            a -= 360.0;
        }
        if ((b = a + this.angleTowardStarboard) > 360.0) {
            b -= 360.0;
        }
        return "Wind from " + (this.angleTowardStarboard == 0.0 ? Double.valueOf(a) : String.valueOf(a) + "-" + b) + "\ufffd (" + this.angleTowardStarboard + "\ufffd)";
    }

    public static enum CombinationModeOnViolation {
        INTERSECTION,
        EXPANSION,
        RANGE_OF_NEXT;

    }
}

