/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.aggregator.hmm.BestPathsCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevel;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelInference;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ManeuverSequenceGraph
implements ManeuverClassificationsAggregator {
    private GraphLevel firstGraphLevel = null;
    private GraphLevel lastGraphLevel = null;
    private final BestPathsCalculator bestPathsCalculator;

    public ManeuverSequenceGraph(BestPathsCalculator bestPathsCalculator) {
        this.bestPathsCalculator = bestPathsCalculator;
    }

    private void appendManeuverAsGraphLevel(ManeuverWithProbabilisticTypeClassification maneuverClassification) {
        GraphLevel newManeuverNodesLevel = new GraphLevel(maneuverClassification, this.bestPathsCalculator.getTransitionProbabilitiesCalculator());
        if (this.firstGraphLevel == null) {
            this.firstGraphLevel = newManeuverNodesLevel;
            this.lastGraphLevel = newManeuverNodesLevel;
        } else {
            this.lastGraphLevel.appendNextManeuverNodesLevel(newManeuverNodesLevel);
            this.lastGraphLevel = newManeuverNodesLevel;
        }
        this.bestPathsCalculator.computeBestPathsToNextLevel(newManeuverNodesLevel);
    }

    protected GraphLevel getFirstGraphLevel() {
        return this.firstGraphLevel;
    }

    protected GraphLevel getLastGraphLevel() {
        return this.lastGraphLevel;
    }

    public void reset() {
        this.firstGraphLevel = null;
        this.lastGraphLevel = null;
    }

    @Override
    public List<ManeuverWithEstimatedType> aggregateManeuverClassifications(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications) {
        this.reset();
        List sortedManeuverClassifications = raceWithManeuverClassifications.getCompetitorTracks().stream().flatMap(competitorTrack -> competitorTrack.getElements().stream()).sorted().collect(Collectors.toList());
        for (ManeuverWithProbabilisticTypeClassification maneuverClassification : sortedManeuverClassifications) {
            this.appendManeuverAsGraphLevel(maneuverClassification);
        }
        ArrayList<ManeuverWithEstimatedType> maneuversWithEstimatedType = new ArrayList<ManeuverWithEstimatedType>();
        List<GraphLevelInference<GraphLevel>> bestPath = this.bestPathsCalculator.getBestPath(this.lastGraphLevel);
        ListIterator<GraphLevelInference<GraphLevel>> iterator = bestPath.listIterator(bestPath.size());
        while (iterator.hasPrevious()) {
            GraphLevelInference<GraphLevel> entry = iterator.previous();
            ManeuverWithEstimatedType maneuverWithEstimatedType = new ManeuverWithEstimatedType(entry.getGraphLevel().getManeuver(), entry.getGraphNode().getManeuverType(), entry.getConfidence());
            maneuversWithEstimatedType.add(maneuverWithEstimatedType);
        }
        return maneuversWithEstimatedType;
    }
}

