/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import java.util.ArrayList;
import java.util.List;

public class GraphLevelBase<GL extends GraphLevelBase<GL>> {
    private final ManeuverForEstimation maneuver;
    private ManeuverWithProbabilisticTypeClassification maneuverClassification;
    private final List<GraphNode<GL>> levelNodes;

    public GraphLevelBase(ManeuverWithProbabilisticTypeClassification maneuverClassification, GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        this.maneuver = maneuverClassification.getManeuver();
        this.maneuverClassification = maneuverClassification;
        this.levelNodes = new ArrayList<GraphNode<GL>>();
        this.initNodes(transitionProbabilitiesCalculator);
    }

    public GraphLevelBase(ManeuverWithProbabilisticTypeClassification maneuverClassification, List<GraphNode<GL>> levelNodes) {
        this.maneuver = maneuverClassification.getManeuver();
        this.maneuverClassification = maneuverClassification;
        this.levelNodes = levelNodes;
    }

    private void initNodes(GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        this.initTackNode(transitionProbabilitiesCalculator);
        this.initJibeNode(transitionProbabilitiesCalculator);
        this.initHeadUpNode(transitionProbabilitiesCalculator);
        this.initBearAwayNode(transitionProbabilitiesCalculator);
        this.normalizeNodeConfidences();
    }

    private void addManeuverNode(ManeuverTypeForClassification maneuverType, Tack tackAfter, WindCourseRange windRange, double confidence) {
        GraphLevelBase thisGL = this;
        GraphNode<GraphLevelBase> maneuverNode = new GraphNode<GraphLevelBase>(maneuverType, tackAfter, windRange, confidence, this.levelNodes.size(), thisGL);
        this.levelNodes.add(maneuverNode);
    }

    private void initBearAwayNode(GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        Tack tackAfter = this.maneuver.getCourseChangeInDegrees() < 0.0 ? Tack.STARBOARD : Tack.PORT;
        WindCourseRange windRange = transitionProbabilitiesCalculator.getWindCourseRangeForManeuverType(this.maneuver, ManeuverTypeForClassification.BEAR_AWAY);
        double confidence = this.maneuverClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.BEAR_AWAY);
        this.addManeuverNode(ManeuverTypeForClassification.BEAR_AWAY, tackAfter, windRange, confidence);
    }

    private void initHeadUpNode(GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        Tack tackAfter = this.maneuver.getCourseChangeInDegrees() < 0.0 ? Tack.PORT : Tack.STARBOARD;
        WindCourseRange windRange = transitionProbabilitiesCalculator.getWindCourseRangeForManeuverType(this.maneuver, ManeuverTypeForClassification.HEAD_UP);
        double confidence = this.maneuverClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.HEAD_UP);
        this.addManeuverNode(ManeuverTypeForClassification.HEAD_UP, tackAfter, windRange, confidence);
    }

    private void initJibeNode(GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        WindCourseRange windRange = transitionProbabilitiesCalculator.getWindCourseRangeForManeuverType(this.maneuver, ManeuverTypeForClassification.JIBE);
        double confidence = this.maneuverClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.JIBE);
        Tack tackAfter = this.maneuver.getCourseChangeWithinMainCurveInDegrees() < 0.0 ? Tack.PORT : Tack.STARBOARD;
        this.addManeuverNode(ManeuverTypeForClassification.JIBE, tackAfter, windRange, confidence);
    }

    private void initTackNode(GraphNodeTransitionProbabilitiesCalculator<GL> transitionProbabilitiesCalculator) {
        WindCourseRange windRange = transitionProbabilitiesCalculator.getWindCourseRangeForManeuverType(this.maneuver, ManeuverTypeForClassification.TACK);
        double confidence = this.maneuverClassification.getManeuverTypeLikelihood(ManeuverTypeForClassification.TACK);
        Tack tackAfter = this.maneuver.getCourseChangeWithinMainCurveInDegrees() < 0.0 ? Tack.STARBOARD : Tack.PORT;
        this.addManeuverNode(ManeuverTypeForClassification.TACK, tackAfter, windRange, confidence);
    }

    public ManeuverForEstimation getManeuver() {
        return this.maneuver;
    }

    public ManeuverWithProbabilisticTypeClassification getManeuverClassification() {
        return this.maneuverClassification;
    }

    public List<GraphNode<GL>> getLevelNodes() {
        return this.levelNodes;
    }

    private void normalizeNodeConfidences() {
        double probabilitiesSum = 0.0;
        for (GraphNode<GL> currentNode : this.levelNodes) {
            probabilitiesSum += currentNode.getConfidence();
        }
        for (GraphNode<GL> currentNode : this.levelNodes) {
            currentNode.setConfidence(currentNode.getConfidence() / probabilitiesSum);
        }
    }

    public String toString() {
        return "Maneuver at " + this.getManeuver().getManeuverTimePoint() + ", " + this.getManeuver().getManeuverPosition() + ", classified as " + this.getLevelNodes();
    }
}

