/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.graph;

import com.sap.sailing.windestimation.aggregator.graph.DijsktraShortestPathFinder;
import com.sap.sailing.windestimation.aggregator.graph.ElementAdjacencyQualityMetric;
import com.sap.sailing.windestimation.aggregator.graph.ElementWithQuality;
import com.sap.sse.common.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public class DijkstraShortestPathFinderImpl<T extends ElementWithQuality>
implements DijsktraShortestPathFinder<T> {
    private final Set<T> visited = new HashSet<T>();
    private final Map<T, T> predecessorsInBestPath = new HashMap<T, T>();
    private final Map<T, Double> qualityOfPathToNode = new HashMap<T, Double>();
    private final Comparator<T> nodeByPathQualityComparator = (node1, node2) -> Comparator.nullsFirst((q1, q2) -> Double.compare(q1, q2)).compare(this.qualityOfPathToNode.get(node1), this.qualityOfPathToNode.get(node2));
    private final SortedSet<T> nodeWithBestQualitySoFar = new TreeSet<T>(this.nodeByPathQualityComparator);
    private final T startNode;
    private final T endNode;
    private final ElementAdjacencyQualityMetric<T> edgeQualitySupplier;

    public DijkstraShortestPathFinderImpl(T startNode, T endNode, Function<T, Iterable<T>> successorSupplier, ElementAdjacencyQualityMetric<T> edgeQualitySupplier) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.edgeQualitySupplier = edgeQualitySupplier;
        this.qualityOfPathToNode.put(startNode, 1.0);
        this.visited.add(startNode);
        this.nodeWithBestQualitySoFar.add(startNode);
        while (!this.visited.contains(endNode)) {
            ElementWithQuality currentNode = (ElementWithQuality)this.nodeWithBestQualitySoFar.last();
            this.nodeWithBestQualitySoFar.remove(currentNode);
            this.visited.add(currentNode);
            Iterable<T> successors = successorSupplier.apply(currentNode);
            if (successors == null || Util.isEmpty(successors)) break;
            double qualityOfPathToCurrent = this.qualityOfPathToNode.get(currentNode);
            for (ElementWithQuality successor : successors) {
                if (this.visited.contains(successor)) continue;
                double qualityOfPathFromCurrentToSuccessor = this.getPathQuality(qualityOfPathToCurrent, currentNode, successor);
                Double qualityOfPathToSuccessorSoFar = this.qualityOfPathToNode.get(successor);
                if (qualityOfPathToSuccessorSoFar != null && !(qualityOfPathFromCurrentToSuccessor > qualityOfPathToSuccessorSoFar)) continue;
                this.nodeWithBestQualitySoFar.remove(successor);
                this.qualityOfPathToNode.put(successor, qualityOfPathFromCurrentToSuccessor);
                this.predecessorsInBestPath.put(successor, currentNode);
                this.nodeWithBestQualitySoFar.add(successor);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Shortest path:\n");
        ElementWithQuality predecessor = null;
        for (ElementWithQuality nodeOnShortestPath : this.getShortestPath()) {
            result.append(nodeOnShortestPath);
            result.append(", cumulative quality: ");
            result.append(this.qualityOfPathToNode.get(nodeOnShortestPath));
            result.append(", transition probability from predecessor: ");
            if (predecessor != null) {
                result.append(this.edgeQualitySupplier.getQuality(predecessor, nodeOnShortestPath));
            }
            result.append("\n");
            predecessor = nodeOnShortestPath;
        }
        return result.toString();
    }

    protected double getPathQuality(double qualityOfPathToCurrent, T currentNode, T successor) {
        return qualityOfPathToCurrent * this.edgeQualitySupplier.getQuality(currentNode, successor) * successor.getQuality();
    }

    protected ElementAdjacencyQualityMetric<T> getEdgeQualitySupplier() {
        return this.edgeQualitySupplier;
    }

    protected T getPredecessorInBestPath(T node) {
        return (T)((ElementWithQuality)this.predecessorsInBestPath.get(node));
    }

    protected T getStartNode() {
        return this.startNode;
    }

    @Override
    public double getPathQuality() {
        return this.qualityOfPathToNode.get(this.endNode);
    }

    @Override
    public Iterable<T> getShortestPath() {
        LinkedList<T> result;
        if (this.visited.contains(this.endNode)) {
            result = new LinkedList<T>();
            Object current = this.endNode;
            while (current != null) {
                result.add(0, current);
                current = (ElementWithQuality)this.predecessorsInBestPath.get(current);
            }
        } else {
            result = null;
        }
        return result;
    }
}

