/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.persistence.impl;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRaceTrackingConnectivityParams;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.domain.yellowbrickadapter.impl.YellowBrickConfigurationImpl;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class YellowBrickConnectivityParamsHandler
extends AbstractRaceTrackingConnectivityParametersHandler {
    private static final String YELLOW_BRICK_USERNAME = "yellowBrickUsername";
    private static final String YELLOW_BRICK_PASSWORD = "yellowBrickPassword";
    private static final String RACE_URL = "raceURL";
    private final RaceLogStore raceLogStore;
    private final RegattaLogStore regattaLogStore;
    private final DomainFactory baseDomainFactory;
    private final SecurityService securityService;
    private final YellowBrickTrackingAdapter yellowBrickTrackingAdapter;

    public YellowBrickConnectivityParamsHandler(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, DomainFactory baseDomainFactory, SecurityService securityService, YellowBrickTrackingAdapter yellowBrickTrackingAdapter) {
        this.raceLogStore = raceLogStore;
        this.regattaLogStore = regattaLogStore;
        this.baseDomainFactory = baseDomainFactory;
        this.securityService = securityService;
        this.yellowBrickTrackingAdapter = yellowBrickTrackingAdapter;
    }

    public Map<String, Object> mapFrom(RaceTrackingConnectivityParameters params) throws MalformedURLException {
        assert (params instanceof YellowBrickRaceTrackingConnectivityParams);
        YellowBrickRaceTrackingConnectivityParams ybParams = (YellowBrickRaceTrackingConnectivityParams)params;
        Map<String, Object> result = this.getKey(params);
        result.put(RACE_URL, ybParams.getRaceUrl() == null ? null : ybParams.getRaceUrl().toString());
        result.put(YELLOW_BRICK_USERNAME, ybParams.getUsername());
        result.put(YELLOW_BRICK_PASSWORD, ybParams.getPassword());
        this.addWindTrackingParameters((RaceTrackingConnectivityParameters)ybParams, result);
        return result;
    }

    public RaceTrackingConnectivityParameters mapTo(Map<String, Object> map) throws Exception {
        return new YellowBrickRaceTrackingConnectivityParams(map.get(RACE_URL).toString(), map.get(YELLOW_BRICK_USERNAME) == null ? null : map.get(YELLOW_BRICK_USERNAME).toString(), map.get(YELLOW_BRICK_PASSWORD) == null ? null : map.get(YELLOW_BRICK_PASSWORD).toString(), this.isTrackWind(map), this.isCorrectWindDirectionByMagneticDeclination(map), this.raceLogStore, this.regattaLogStore, this.baseDomainFactory, this.yellowBrickTrackingAdapter);
    }

    public Map<String, Object> getKey(RaceTrackingConnectivityParameters params) throws MalformedURLException {
        assert (params instanceof YellowBrickRaceTrackingConnectivityParams);
        YellowBrickRaceTrackingConnectivityParams ybParams = (YellowBrickRaceTrackingConnectivityParams)params;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", params.getTypeIdentifier());
        result.put(RACE_URL, ybParams.getRaceUrl());
        return result;
    }

    public RaceTrackingConnectivityParameters resolve(RaceTrackingConnectivityParameters params) throws Exception {
        assert (params instanceof YellowBrickRaceTrackingConnectivityParams);
        YellowBrickRaceTrackingConnectivityParams ybParams = (YellowBrickRaceTrackingConnectivityParams)params;
        YellowBrickRaceTrackingConnectivityParams result = new YellowBrickRaceTrackingConnectivityParams(ybParams.getRaceUrl(), ybParams.getUsername(), ybParams.getPassword(), ybParams.isTrackWind(), ybParams.isCorrectWindDirectionByMagneticDeclination(), this.raceLogStore, this.regattaLogStore, this.baseDomainFactory, this.yellowBrickTrackingAdapter);
        this.updatePersistentYellowBrickConfiguration(result);
        return result;
    }

    private void updatePersistentYellowBrickConfiguration(YellowBrickRaceTrackingConnectivityParams params) throws MalformedURLException, IOException, ParseException, URISyntaxException {
        String creatorName = SessionUtils.getPrincipal().toString();
        YellowBrickConfigurationImpl yellowBrickConfiguration = new YellowBrickConfigurationImpl(params.getRaceUrl(), params.getRaceUrl(), params.getUsername(), params.getPassword(), creatorName);
        this.yellowBrickTrackingAdapter.addYellowBrickConfiguration((YellowBrickConfiguration)yellowBrickConfiguration);
        this.securityService.setDefaultOwnershipIfNotSet(yellowBrickConfiguration.getIdentifier());
    }
}

