/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.MasterDataImportClassLoaderService;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapterFactory;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayServiceFactory;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.MasterDataImportClassLoaderServiceImpl;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayConnectivityParamsHandler;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayServiceFactoryImpl;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private final SwissTimingReplayServiceFactory swissTimingReplayServiceFactory = new SwissTimingReplayServiceFactoryImpl();

    public void start(BundleContext context) throws Exception {
        context.registerService(SwissTimingReplayServiceFactory.class.getName(), (Object)this.swissTimingReplayServiceFactory, null);
        context.registerService(MasterDataImportClassLoaderService.class, (Object)new MasterDataImportClassLoaderServiceImpl(), null);
        new Thread(() -> {
            ServiceTracker mongoObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, MongoObjectFactory.class);
            ServiceTracker domainObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, DomainObjectFactory.class);
            ServiceTracker swissTimingAdapterFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SwissTimingAdapterFactory.class);
            ServiceTracker raceLogResolverServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, RaceLogResolver.class);
            FullyInitializedReplicableTracker securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
            try {
                MongoObjectFactory mongoObjectFactory = (MongoObjectFactory)mongoObjectFactoryServiceTracker.waitForService(0L);
                DomainObjectFactory domainObjectFactory = (DomainObjectFactory)domainObjectFactoryServiceTracker.waitForService(0L);
                SwissTimingAdapterFactory swissTimingAdapterFactory = (SwissTimingAdapterFactory)swissTimingAdapterFactoryServiceTracker.waitForService(0L);
                RaceLogResolver raceLogResolver = (RaceLogResolver)raceLogResolverServiceTracker.waitForService(0L);
                SecurityService securityService = (SecurityService)securityServiceTracker.getInitializedService(0L);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                DomainFactory domainFactory = swissTimingAdapterFactory.getOrCreateSwissTimingAdapter(domainObjectFactory.getBaseDomainFactory()).getSwissTimingDomainFactory();
                SwissTimingReplayConnectivityParamsHandler paramsHandler = new SwissTimingReplayConnectivityParamsHandler(MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(mongoObjectFactory, domainObjectFactory), MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(mongoObjectFactory, domainObjectFactory), domainFactory, this.swissTimingReplayServiceFactory.createSwissTimingReplayService(domainFactory, raceLogResolver), securityService);
                ((Dictionary)properties).put("type", "SWISS_TIMING_REPLAY");
                context.registerService(RaceTrackingConnectivityParametersHandler.class, (Object)paramsHandler, properties);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception trying to register SwissTiming Replay RaceTrackingConnectivityParametersHandler implementation", e);
            }
        }, String.valueOf(this.getClass().getName()) + " registering connectivity handler").start();
        logger.log(Level.INFO, "Started " + context.getBundle().getSymbolicName());
    }

    public void stop(BundleContext context) throws Exception {
    }
}

