/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.expedition;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sailing.server.gateway.windimport.expedition.WindLogParser;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WindImporter
extends AbstractWindImporter {
    @Override
    protected WindSource getDefaultWindSource(AbstractWindImporter.UploadRequest uploadRequest) {
        Object windSource = uploadRequest.boatId == null ? new WindSourceImpl(WindSourceType.EXPEDITION) : new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, uploadRequest.boatId);
        return windSource;
    }

    @Override
    protected Map<WindSource, Iterable<Wind>> importWind(WindSource defaultWindSource, Map<InputStream, Util.Pair<String, Charset>> streamsWithFilenames) throws IOException, FormatNotSupportedException {
        final ArrayList windFixes = new ArrayList();
        for (Map.Entry<InputStream, Util.Pair<String, Charset>> entry : streamsWithFilenames.entrySet()) {
            CompressedStreamsUtil.handlePotentiallyCompressedFiles((String)((String)entry.getValue().getA()), (InputStream)entry.getKey(), (Charset)((Charset)entry.getValue().getB()), (CompressedStreamsUtil.FileHandler)new ExpeditionImportFileHandler(){

                protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset) throws IOException {
                    Util.addAll(WindLogParser.importWind(inputStream), (Collection)windFixes);
                }
            });
        }
        HashMap<WindSource, Iterable<Wind>> result = new HashMap<WindSource, Iterable<Wind>>();
        result.put(defaultWindSource, windFixes);
        return result;
    }
}

