/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.trackfiles.TrackFilesDataSource;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.SailingServerHttpServlet;
import com.sap.sailing.server.trackfiles.TrackFileExporter;
import com.sap.sse.security.shared.HasPermissions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;

public class TrackFilesExportPostServlet
extends SailingServerHttpServlet {
    private static final long serialVersionUID = 1120226743039934620L;
    private static final Logger log = Logger.getLogger(TrackFilesExportPostServlet.class.toString());

    private TrackedRace getTrackedRace(String regattaString, String raceString) {
        RaceDefinition race;
        Regatta regatta = this.getService().getRegattaByName(regattaString);
        DynamicTrackedRace result = regatta == null ? null : ((race = regatta.getRaceByName(raceString)) == null ? null : this.getService().getTrackedRace(regatta, race));
        return result;
    }

    private List<TrackedRace> getTrackedRaces(String[] regattaRaces) {
        ArrayList<TrackedRace> races = new ArrayList<TrackedRace>();
        String[] stringArray = regattaRaces;
        int n = regattaRaces.length;
        int n2 = 0;
        while (n2 < n) {
            String raceString;
            String regattaString;
            TrackedRace trackedRace;
            String regattaRace = stringArray[n2];
            String[] split = regattaRace.split(":");
            if (split.length != 0 && (trackedRace = this.getTrackedRace(regattaString = split[0], raceString = split[1])) != null) {
                races.add(trackedRace);
            }
            ++n2;
        }
        return races;
    }

    private boolean isParamValid(HttpServletResponse resp, Object param, String name) throws IOException {
        if (param == null) {
            resp.sendError(400, "POST Parameter not passed: " + name);
            return false;
        }
        return true;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] regattaRaces = req.getParameterValues("regattaraces");
        String formatString = req.getParameter("format");
        String[] dataString = req.getParameterValues("data");
        String beforeAfterString = req.getParameter("before_after");
        String rawFixesString = req.getParameter("raw_fixes");
        if (!(this.isParamValid(resp, regattaRaces, "regattaraces") && this.isParamValid(resp, formatString, "format") && this.isParamValid(resp, dataString, "data"))) {
            return;
        }
        resp.setHeader("Content-Disposition", "attachment; filename=\"tracked-races.zip\"");
        resp.setContentType("application/zip");
        List<TrackedRace> trackedRaces = this.getTrackedRaces(regattaRaces);
        for (TrackedRace trackedRace : trackedRaces) {
            SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.EXPORT));
        }
        ZipOutputStream out = new ZipOutputStream((OutputStream)resp.getOutputStream());
        boolean beforeAfter = beforeAfterString != null;
        boolean rawFixes = rawFixesString != null;
        TrackFilesFormat format = TrackFilesFormat.valueOf((String)formatString);
        ArrayList<TrackFilesDataSource> data = new ArrayList<TrackFilesDataSource>();
        String[] stringArray = dataString;
        int n = dataString.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            data.add(TrackFilesDataSource.valueOf((String)s));
            ++n2;
        }
        try {
            TrackFileExporter.INSTANCE.writeAllData(data, format, trackedRaces, beforeAfter, rawFixes, out);
        }
        catch (Exception e) {
            resp.sendError(400, "Error trying to export data; see server logs for details.");
            log.log(Level.WARNING, e.getMessage());
        }
        out.flush();
        out.close();
    }
}

