/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sse.common.TimeRange;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImportResult {
    private final List<ErrorImportDTO> errorList = new CopyOnWriteArrayList<ErrorImportDTO>();
    private final List<TrackImportDTO> importResult = new CopyOnWriteArrayList<TrackImportDTO>();
    private final Logger logger;

    ImportResult(Logger logger) {
        this.logger = logger;
    }

    void add(String requestedImporterName, String filename, Exception exception) {
        this.logger.log(Level.SEVERE, "Sensordata import importer: " + requestedImporterName);
        this.logger.log(Level.SEVERE, "Sensordata import filename: " + filename);
        this.logException(exception, filename, requestedImporterName);
    }

    void add(Exception exception) {
        this.logException(exception, "", "");
    }

    private void logException(Exception exception, String filename, String requestedImporterName) {
        String exUUID = UUID.randomUUID().toString();
        String exClass = exception.getClass().getName();
        this.logger.log(Level.SEVERE, "Sensordata import ExUUID: " + exUUID, exception);
        this.errorList.add(new ErrorImportDTO(exUUID, exClass, exception.getMessage(), filename, requestedImporterName));
    }

    void noImporterSucceeded(String filename) {
        this.errorList.add(new ErrorImportDTO(null, null, "No importer succeeded to process file", filename, null));
    }

    void addTrackData(TrackImportDTO trackImportDTO) {
        this.importResult.add(trackImportDTO);
    }

    List<ErrorImportDTO> getErrorList() {
        return this.errorList;
    }

    List<TrackImportDTO> getImportResult() {
        return this.importResult;
    }

    static class ErrorImportDTO {
        private final String exUUID;
        private final String name;
        private final String message;
        private final String filename;
        private final String requestedImporter;

        ErrorImportDTO(String message) {
            this(null, null, message, null, null);
        }

        ErrorImportDTO(String classname, String message) {
            this(null, classname, message, null, null);
        }

        ErrorImportDTO(String exUUID, String name, String message, String filename, String requestedImporter) {
            this.exUUID = exUUID;
            this.name = name;
            this.message = message;
            this.filename = filename;
            this.requestedImporter = requestedImporter;
        }

        String getExUUID() {
            return this.exUUID;
        }

        String getName() {
            return this.name;
        }

        String getMessage() {
            return this.message;
        }

        String getFilename() {
            return this.filename;
        }

        String getRequestedImporter() {
            return this.requestedImporter;
        }
    }

    static class TrackImportDTO {
        private final TimeRange range;
        private final long amount;
        private final UUID device;

        TrackImportDTO(UUID device, TimeRange range, long amount) {
            this.device = device;
            this.range = range;
            this.amount = amount;
        }

        TimeRange getRange() {
            return this.range;
        }

        UUID getDevice() {
            return this.device;
        }

        long getAmount() {
            return this.amount;
        }
    }
}

