/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription.chargebee;

import com.sap.sailing.server.gateway.subscription.chargebee.SubscriptionWebHookEventType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.shared.subscription.Subscription;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SubscriptionWebHookEvent {
    private static final Logger logger = Logger.getLogger(SubscriptionWebHookEvent.class.getName());
    public static final String SUBSCRIPTION_STATUS_ACTIVE = "active";
    public static final String INVOICE_STATUS_PAID = "paid";
    private static final String CONTENT_JSON_OBJECT = "content";
    private static final String EVENT_ID = "id";
    private static final String EVENT_OCCURRED_AT = "occurred_at";
    private static final String EVENT_TYPE = "event_type";
    private static final String CUSTOMER_JSON_OBJECT = "customer";
    private static final String CUSTOMER_ID = "id";
    private static final String CUSTOMER_EMAIL = "email";
    private static final String SUBSCRIPTION_JSON_OBJECT = "subscription";
    private static final String SUBSCRIPTION_ID = "id";
    private static final String SUBSCRIPTION_PLAN_ID = "plan_id";
    private static final String SUBSCRIPTION_STATUS = "status";
    private static final String SUBSCRIPTION_TRIAL_START = "trial_start";
    private static final String SUBSCRIPTION_TRIAL_END = "trial_end";
    private static final String SUBSCRIPTION_CREATED_AT = "created_at";
    private static final String SUBSCRIPTION_UPDTAED_AT = "updated_at";
    private static final String TRANSACTION_JSON_OBJECT = "transaction";
    private static final String TRANSACTION_STATUS = "status";
    private static final String TRANSACTION_TYPE = "type";
    private static final String INVOICE_JSON_OBJECT = "invoice";
    private static final String INVOICE_ID = "id";
    private static final String INVOICE_CUSTOMER_ID = "customer_id";
    private static final String INVOICE_SUBSCRIPTION_ID = "subscription_id";
    private static final String INVOICE_STATUS = "status";
    private static final String NEXT_BILLING_AT = "next_billing_at";
    private static final String CURRENT_TERM_END = "current_term_end";
    private static final String CANCELLED_AT = "cancelled_at";
    private static final String SUBSCRIPTION_ACTIVATED_AT = "subscription_activated_at";
    private static final String CURRENCY_CODE = "currency_code";
    private final JSONObject eventJSON;
    private final String eventId;
    private final SubscriptionWebHookEventType eventType;
    private final JSONObject content;

    public SubscriptionWebHookEvent(JSONObject eventJSON) {
        this.eventJSON = eventJSON;
        this.eventId = (String)SubscriptionWebHookEvent.getJsonValue(eventJSON, "id");
        this.eventType = this.getEventType(eventJSON);
        this.content = (JSONObject)SubscriptionWebHookEvent.getJsonValue(eventJSON, CONTENT_JSON_OBJECT);
    }

    public boolean isValidEvent() {
        return this.eventId != null;
    }

    public String getEventId() {
        return this.eventId;
    }

    private SubscriptionWebHookEventType getEventType(JSONObject eventJSON) {
        String eventTypeAsUppercaseString = this.toUpperCase((String)SubscriptionWebHookEvent.getJsonValue(eventJSON, EVENT_TYPE));
        try {
            return SubscriptionWebHookEventType.valueOf(eventTypeAsUppercaseString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.warning(() -> "Exception trying to extract subscription event type " + eventTypeAsUppercaseString + ": " + e.getMessage());
            return null;
        }
    }

    public SubscriptionWebHookEventType getEventType() {
        return this.eventType;
    }

    public String getCustomerEmail() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, CUSTOMER_JSON_OBJECT, CUSTOMER_EMAIL);
    }

    public String getCustomerId() {
        String customerId = (String)SubscriptionWebHookEvent.getJsonValue(this.content, CUSTOMER_JSON_OBJECT, "id");
        if (StringUtils.isEmpty((String)customerId)) {
            customerId = this.getInvoiceCustomerId();
        }
        return customerId;
    }

    public String getPlanId() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_PLAN_ID);
    }

    public String getItemPriceId() {
        String itemPriceId = null;
        JSONArray subscriptionItems = (JSONArray)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, "subscription_items");
        if (subscriptionItems != null) {
            int i = 0;
            while (i < subscriptionItems.size()) {
                String itemType = (String)SubscriptionWebHookEvent.getJsonValue((JSONObject)subscriptionItems.get(i), "item_type");
                if ("plan".equals(itemType)) {
                    itemPriceId = (String)SubscriptionWebHookEvent.getJsonValue((JSONObject)subscriptionItems.get(i), "item_price_id");
                }
                ++i;
            }
        }
        return itemPriceId;
    }

    public String getSubscriptionId() {
        String subscriptionId = (String)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, "id");
        if (StringUtils.isEmpty((String)subscriptionId)) {
            subscriptionId = this.getInvoiceSubscriptionId();
        }
        return subscriptionId;
    }

    public String getSubscriptionStatus() {
        return this.toLowerCase((String)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, "status"));
    }

    public TimePoint getSubscriptionTrialStart() {
        Long jsonValue = (Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_TRIAL_START);
        return this.getTime(jsonValue);
    }

    public TimePoint getSubscriptionTrialEnd() {
        Long jsonValue = (Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_TRIAL_END);
        return this.getTime(jsonValue);
    }

    public TimePoint getSubscriptionCreatedAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_CREATED_AT));
    }

    public TimePoint getSubscriptionUpdatedAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_UPDTAED_AT));
    }

    public TimePoint getEventOccurredAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.eventJSON, EVENT_OCCURRED_AT));
    }

    public String getTransactionStatus() {
        return this.toLowerCase((String)SubscriptionWebHookEvent.getJsonValue(this.content, TRANSACTION_JSON_OBJECT, "status"));
    }

    public String getTransactionType() {
        return this.toLowerCase((String)SubscriptionWebHookEvent.getJsonValue(this.content, TRANSACTION_JSON_OBJECT, TRANSACTION_TYPE));
    }

    public String getInvoiceId() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, INVOICE_JSON_OBJECT, "id");
    }

    public String getInvoiceCustomerId() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, INVOICE_JSON_OBJECT, INVOICE_CUSTOMER_ID);
    }

    public String getInvoiceSubscriptionId() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, INVOICE_JSON_OBJECT, INVOICE_SUBSCRIPTION_ID);
    }

    public String getInvoiceStatus() {
        return this.toLowerCase((String)SubscriptionWebHookEvent.getJsonValue(this.content, INVOICE_JSON_OBJECT, "status"));
    }

    public TimePoint getBillingAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, NEXT_BILLING_AT));
    }

    public TimePoint getCurrentTermEnd() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, CURRENT_TERM_END));
    }

    public TimePoint getCancelledAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, CANCELLED_AT));
    }

    public TimePoint getActivatedAt() {
        return this.getTime((Long)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, SUBSCRIPTION_ACTIVATED_AT));
    }

    public Integer getReocurringPaymentValue() {
        int reocurringPaymentValue = 0;
        JSONArray subscriptionItems = (JSONArray)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, "subscription_items");
        if (subscriptionItems != null) {
            int i = 0;
            while (i < subscriptionItems.size()) {
                Long amount = (Long)SubscriptionWebHookEvent.getJsonValue((JSONObject)subscriptionItems.get(i), "amount");
                if (amount != null) {
                    reocurringPaymentValue += amount.intValue();
                }
                ++i;
            }
        }
        return reocurringPaymentValue;
    }

    public String getCurrencyCode() {
        return (String)SubscriptionWebHookEvent.getJsonValue(this.content, SUBSCRIPTION_JSON_OBJECT, CURRENCY_CODE);
    }

    private TimePoint getTime(Long timestamp) {
        return timestamp == null ? Subscription.emptyTime() : Subscription.getTime((long)(timestamp * 1000L));
    }

    private static <T> T getJsonValue(JSONObject object, String ... keys) {
        if (keys.length == 1) {
            return (T)object.get((Object)keys[0]);
        }
        return SubscriptionWebHookEvent.getNestedJsonValue(object, keys);
    }

    private static <T> T getNestedJsonValue(JSONObject object, String ... keys) {
        JSONObject tmp = object;
        T val = null;
        int i = 0;
        while (i < keys.length) {
            if (i < keys.length - 1) {
                if ((tmp = (JSONObject)SubscriptionWebHookEvent.getJsonValue(tmp, keys[i])) == null) {
                    break;
                }
            } else {
                val = SubscriptionWebHookEvent.getJsonValue(tmp, keys[i]);
            }
            ++i;
        }
        return val;
    }

    private String toLowerCase(String str) {
        return str != null ? str.toLowerCase() : null;
    }

    private String toUpperCase(String str) {
        return str != null ? str.toUpperCase() : null;
    }
}

