/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Timed;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public final class TrackingDeviceStatus {
    private static final Logger logger = Logger.getLogger(TrackingDeviceStatus.class.getName());
    private final DeviceIdentifier deviceId;
    private final GPSFix lastFix;

    public TrackingDeviceStatus(DeviceIdentifier deviceId, GPSFix lastFix) {
        this.deviceId = deviceId;
        this.lastFix = lastFix;
    }

    public DeviceIdentifier getDeviceId() {
        return this.deviceId;
    }

    public GPSFix getLastGPSFix() {
        return this.lastFix;
    }

    public static TrackingDeviceStatus calculateDeviceStatus(DeviceIdentifier deviceIdentifier, RacingEventService service) {
        try {
            Map lastFixMap = service.getSensorFixStore().getFixLastReceived(Collections.singletonList(deviceIdentifier));
            Timed lastFix = (Timed)lastFixMap.get(deviceIdentifier);
            GPSFix lastGPSFix = lastFix instanceof GPSFix ? (GPSFix)lastFix : null;
            return new TrackingDeviceStatus(deviceIdentifier, lastGPSFix);
        }
        catch (Exception e) {
            String errorMessage = "Error while loading device status for device " + deviceIdentifier;
            logger.log(Level.SEVERE, errorMessage, e);
            throw new WebApplicationException(Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)errorMessage).build());
        }
    }
}

