/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.server.gateway.serialization.impl.DetailedRaceInfoJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.SimpleRaceInfoJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/trackedRaces")
public class TrackedRaceListResource
extends AbstractSailingServerResource {
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_JSON_UTF8 = "application/json;charset=UTF-8";
    private final SimpleRaceInfoJsonSerializer simpleRaceListJsonSerializer = new SimpleRaceInfoJsonSerializer();
    private final DetailedRaceInfoJsonSerializer detailedRaceListJsonSerializer = new DetailedRaceInfoJsonSerializer();

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="raceDetails")
    public Response getDetailsForRace(@QueryParam(value="raceName") String raceName, @QueryParam(value="regattaName") String regattaName) {
        DetailedRaceInfo detailedRaceInfo = this.getService().getFullDetailsForRaceLocal((RegattaAndRaceIdentifier)new RegattaNameAndRaceName(regattaName, raceName));
        if (detailedRaceInfo == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).header(HEADER_NAME_CONTENT_TYPE, (Object)CONTENT_TYPE_JSON_UTF8).build();
        }
        return this.getJsonResponse(this.streamingOutput(this.detailedRaceListJsonSerializer.serialize(detailedRaceInfo)));
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="getRaces")
    public Response raceListPost(@FormParam(value="transitive") @DefaultValue(value="false") Boolean transitive, @FormParam(value="events") @DefaultValue(value="") String strEvents, @FormParam(value="pred") @DefaultValue(value="excl") String predicate) {
        return this.raceList(transitive, strEvents, predicate);
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="getRaces")
    @Deprecated
    public Response raceList(@QueryParam(value="transitive") @DefaultValue(value="false") Boolean transitive, @QueryParam(value="events") @DefaultValue(value="") String strEvents, @QueryParam(value="pred") @DefaultValue(value="excl") String predicate) {
        Predicate<UUID> eventFilter;
        boolean includeRemotes = transitive != null && Boolean.TRUE.equals(transitive);
        Set eventUUIDs = Arrays.asList(strEvents.split(",")).stream().filter(StringUtils::isNotBlank).map(UUID::fromString).collect(Collectors.toSet());
        if ("incl".equals(predicate)) {
            eventFilter = uuid -> eventUUIDs.contains(uuid);
        } else if ("excl".equals(predicate)) {
            eventFilter = uuid -> !eventUUIDs.contains(uuid);
        } else {
            throw new IllegalArgumentException("unrecognized predicate " + predicate + " only \"excl\" and \"incl\" are possible");
        }
        Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> distinctRaces = this.getDistinctRaces(includeRemotes, eventFilter);
        HashMap raceData = new HashMap();
        distinctRaces.values().stream().flatMap(Collection::stream).forEach(raceInfo -> {
            String remoteUrl = raceInfo.getRemoteUrl() == null ? null : raceInfo.getRemoteUrl().toExternalForm();
            ArrayList<SimpleRaceInfo> remoteList = (ArrayList<SimpleRaceInfo>)raceData.get(remoteUrl);
            if (remoteList == null) {
                remoteList = new ArrayList<SimpleRaceInfo>();
                raceData.put(remoteUrl, remoteList);
            }
            remoteList.add((SimpleRaceInfo)raceInfo);
        });
        JSONArray json = new JSONArray();
        for (Map.Entry raced : raceData.entrySet()) {
            JSONArray list = new JSONArray();
            for (SimpleRaceInfo simpleRaceInfo : (List)raced.getValue()) {
                list.add((Object)this.simpleRaceListJsonSerializer.serialize(simpleRaceInfo));
            }
            JSONObject remote = new JSONObject();
            remote.put((Object)"remoteUrl", raced.getKey());
            remote.put((Object)"races", (Object)list);
            json.add((Object)remote);
        }
        return this.getJsonResponse(this.streamingOutput(json));
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="allRaces")
    public Response fullRaceList() {
        JSONArray json = new JSONArray();
        Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> store = this.getDistinctRaces(true, uuid -> true);
        List sorted = store.values().stream().flatMap(races -> races.stream()).sorted((o1, o2) -> o1.getStartOfRace().compareTo((Object)o2.getStartOfRace())).collect(Collectors.toList());
        int i = 0;
        while (i < sorted.size()) {
            SimpleRaceInfo current = (SimpleRaceInfo)sorted.get(i);
            JSONObject raceInfo = new JSONObject();
            raceInfo.put((Object)"racenumber", (Object)String.valueOf(i));
            URL remoteUrl = current.getRemoteUrl();
            raceInfo.put((Object)"remoteUrl", (Object)(remoteUrl == null ? null : remoteUrl.toExternalForm()));
            raceInfo.put((Object)"raceinfo", (Object)this.simpleRaceListJsonSerializer.serialize(current));
            json.add((Object)raceInfo);
            ++i;
        }
        return this.getJsonResponse(this.streamingOutput(json));
    }

    private Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> getDistinctRaces(boolean includeRemotes, Predicate<UUID> eventListFilter) {
        Map distinctRaces = this.getService().getLocalRaceList(eventListFilter);
        if (includeRemotes) {
            this.getService().getRemoteRaceList(eventListFilter).forEach((identifier, simpleRaceInfoSet) -> {
                Set set = distinctRaces.compute(identifier, (key, valueSet) -> {
                    Set mergedSet;
                    if (valueSet != null) {
                        valueSet.addAll(simpleRaceInfoSet);
                        mergedSet = valueSet;
                    } else {
                        mergedSet = simpleRaceInfoSet;
                    }
                    return mergedSet;
                });
            });
        }
        return distinctRaces;
    }

    private Response getJsonResponse(StreamingOutput json) {
        return Response.ok((Object)json).header(HEADER_NAME_CONTENT_TYPE, (Object)CONTENT_TYPE_JSON_UTF8).build();
    }
}

