/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.server.gateway.serialization.impl.StatisticsByYearJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.StatisticsJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;

@Path(value="/v1/statistics")
public class StatisticsResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(StatisticsResource.class.getName());
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_JSON_UTF8 = "application/json;charset=UTF-8";
    private final StatisticsByYearJsonSerializer statisticsByYearJsonSerializer = new StatisticsByYearJsonSerializer(new StatisticsJsonSerializer());

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="years")
    public Response getStatisticsByYear(@QueryParam(value="years") List<String> years) {
        Predicate<Map.Entry> filterPredicate;
        JSONArray json = new JSONArray();
        Map statisticsByYear = this.getService().getLocalStatisticsByYear();
        if (years != null && !years.isEmpty()) {
            Set<Integer> yearsToReturn = this.toIntegerYears(years);
            filterPredicate = entry -> yearsToReturn.contains(entry.getKey());
        } else {
            filterPredicate = entry -> true;
        }
        statisticsByYear.entrySet().stream().filter(filterPredicate).forEach(entry -> {
            boolean bl = json.add((Object)this.statisticsByYearJsonSerializer.serialize(new Util.Pair((Object)((Integer)entry.getKey()), (Object)((Statistics)entry.getValue()))));
        });
        return this.getJsonResponse(json);
    }

    private Set<Integer> toIntegerYears(List<String> years) {
        HashSet<Integer> integerYears = new HashSet<Integer>();
        for (String yearString : years) {
            try {
                integerYears.add(Integer.valueOf(yearString.trim()));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e, () -> "error while parsing year '" + yearString + "'");
            }
        }
        return integerYears;
    }

    private Response getJsonResponse(JSONArray jsonArray) {
        return Response.ok((Object)this.streamingOutput(jsonArray)).header(HEADER_NAME_CONTENT_TYPE, (Object)CONTENT_TYPE_JSON_UTF8).build();
    }
}

