/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.server.gateway.jaxrs.api.AbstractLeaderboardsResource;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v2/leaderboards")
public class LeaderboardsResourceV2
extends AbstractLeaderboardsResource {
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{name}")
    public Response getLeaderboard(@PathParam(value="name") String leaderboardName, @DefaultValue(value="Live") @QueryParam(value="resultState") AbstractLeaderboardsResource.ResultStates resultState, @QueryParam(value="columnNames") List<String> raceColumnNames, @QueryParam(value="raceDetails") List<String> raceDetails, @QueryParam(value="time") String time, @QueryParam(value="timeasmillis") Long timeasmillis, @QueryParam(value="maxCompetitorsCount") Integer maxCompetitorsCount, @QueryParam(value="secret") String regattaSecret, @DefaultValue(value="false") @QueryParam(value="competitorAndBoatIdsOnly") boolean competitorAndBoatIdsOnly, @QueryParam(value="showOnlyActiveRacesForCompetitorIds") List<String> showOnlyActiveRacesForCompetitorIds, @DefaultValue(value="False") @QueryParam(value="showOnlyCompetitorsWithIdsProvided") Boolean showOnlyCompetitorsWithIdsProvided) {
        ShardingContext.setShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME, (String)leaderboardName);
        try {
            Response response;
            Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
            if (leaderboard == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            } else {
                TimePoint timePoint;
                boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret);
                if (!skip) {
                    this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
                }
                try {
                    timePoint = this.parseTimePoint(time, timeasmillis, this.calculateTimePointForResultState(leaderboard, resultState));
                }
                catch (InvalidDateException e1) {
                    Response response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not parse the time.").type("text/plain").build();
                    ShardingContext.clearShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME);
                    return response2;
                }
                try {
                    JSONObject jsonLeaderboard = timePoint != null || resultState == AbstractLeaderboardsResource.ResultStates.Live ? this.getLeaderboardJson(leaderboard, timePoint, resultState, maxCompetitorsCount, raceColumnNames, raceDetails, competitorAndBoatIdsOnly, showOnlyActiveRacesForCompetitorIds, skip, showOnlyCompetitorsWithIdsProvided) : this.createEmptyLeaderboardJson(leaderboard, resultState, maxCompetitorsCount, skip);
                    response = Response.ok((Object)this.streamingOutput(jsonLeaderboard)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
                }
                catch (NoWindException | InterruptedException | ExecutionException e) {
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
                }
            }
            Response response3 = response;
            return response3;
        }
        finally {
            ShardingContext.clearShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME);
        }
    }

    @Override
    protected JSONObject getLeaderboardJson(Leaderboard leaderboard, TimePoint resultTimePoint, AbstractLeaderboardsResource.ResultStates resultState, Integer maxCompetitorsCount, List<String> raceColumnNames, List<String> raceDetailNames, boolean competitorAndBoatIdsOnly, List<String> showOnlyActiveRacesForCompetitorIds, boolean userPresentedValidRegattaSecret, boolean showOnlyCompetitorsWithIdsProvided) throws NoWindException, InterruptedException, ExecutionException {
        List<String> raceColumnsToShow = this.calculateRaceColumnsToShow(leaderboard, raceColumnNames, showOnlyActiveRacesForCompetitorIds, resultTimePoint);
        List<DetailType> raceDetailsToShow = this.calculateRaceDetailTypesToShow(raceDetailNames);
        LeaderboardDTO leaderboardDTO = leaderboard.getLeaderboardDTO(resultTimePoint, raceColumnsToShow, this.hasOverallDetail(raceDetailsToShow), (TrackedRegattaRegistry)this.getService(), this.getService().getBaseDomainFactory(), false);
        MillisecondsTimePoint leaderboardTimePoint = new MillisecondsTimePoint(leaderboardDTO.getTimePoint());
        JSONObject jsonLeaderboard = new JSONObject();
        this.writeCommonLeaderboardData(jsonLeaderboard, leaderboard, resultState, leaderboardDTO.getTimePoint(), maxCompetitorsCount);
        HashMap competitorRanksPerRaceColumnsAndFleets = new HashMap();
        for (String raceColumnName : raceColumnsToShow) {
            List competitorsFromBestToWorst = leaderboardDTO.getCompetitorsFromBestToWorst(raceColumnName);
            HashMap<String, HashMap<CompetitorDTO, Integer>> competitorsOrderedByFleets = new HashMap<String, HashMap<CompetitorDTO, Integer>>();
            ArrayList filteredCompetitorsFromBestToWorst = new ArrayList();
            competitorsFromBestToWorst.forEach(competitor -> {
                if (userPresentedValidRegattaSecret || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC)) || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) {
                    filteredCompetitorsFromBestToWorst.add(competitor);
                }
            });
            for (CompetitorDTO competitor2 : filteredCompetitorsFromBestToWorst) {
                FleetDTO fleetOfCompetitor;
                LeaderboardRowDTO row = (LeaderboardRowDTO)leaderboardDTO.rows.get(competitor2);
                LeaderboardEntryDTO leaderboardEntry = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(raceColumnName);
                FleetDTO fleetDTO = fleetOfCompetitor = leaderboardEntry == null ? null : leaderboardEntry.fleet;
                if (fleetOfCompetitor == null || fleetOfCompetitor.getName() == null) continue;
                HashMap<CompetitorDTO, Integer> competitorsOfFleet = (HashMap<CompetitorDTO, Integer>)competitorsOrderedByFleets.get(fleetOfCompetitor.getName());
                if (competitorsOfFleet == null) {
                    competitorsOfFleet = new HashMap<CompetitorDTO, Integer>();
                    competitorsOrderedByFleets.put(fleetOfCompetitor.getName(), competitorsOfFleet);
                }
                competitorsOfFleet.put(competitor2, competitorsOfFleet.size() + 1);
            }
            competitorRanksPerRaceColumnsAndFleets.put(raceColumnName, competitorsOrderedByFleets);
        }
        JSONArray jsonCompetitorEntries = new JSONArray();
        jsonLeaderboard.put((Object)"competitors", (Object)jsonCompetitorEntries);
        int[] regattaRankCounter = new int[]{1};
        ArrayList filteredCompetitors = new ArrayList();
        HashMap ranks = new HashMap();
        leaderboardDTO.competitors.forEach(competitor -> {
            int n = regattaRankCounter[0];
            nArray[0] = n + 1;
            ranks.put(competitor, n);
            if ((SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC)) || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) && (!showOnlyCompetitorsWithIdsProvided || showOnlyActiveRacesForCompetitorIds.contains(competitor.getId().toString()))) {
                filteredCompetitors.add(competitor);
            }
        });
        int competitorCounter = 0;
        for (CompetitorDTO competitor2 : filteredCompetitors) {
            LeaderboardRowDTO leaderboardRowDTO = (LeaderboardRowDTO)leaderboardDTO.rows.get(competitor2);
            if (maxCompetitorsCount != null && competitorCounter >= maxCompetitorsCount) break;
            JSONObject jsonCompetitor = new JSONObject();
            this.writeCompetitorBaseData(jsonCompetitor, competitor2, leaderboardDTO, competitorAndBoatIdsOnly);
            BoatDTO rowBoatDTO = leaderboardRowDTO.boat;
            if (rowBoatDTO != null) {
                JSONObject jsonBoat = new JSONObject();
                this.writeBoatData(jsonBoat, rowBoatDTO, competitorAndBoatIdsOnly);
                jsonCompetitor.put((Object)"boat", (Object)jsonBoat);
            }
            jsonCompetitor.put((Object)"rank", ranks.get(competitor2));
            jsonCompetitor.put((Object)"carriedPoints", (Object)leaderboardRowDTO.carriedPoints);
            jsonCompetitor.put((Object)"netPoints", (Object)leaderboardRowDTO.netPoints);
            jsonCompetitor.put((Object)"overallRank", (Object)leaderboardDTO.getTotalRank(competitor2));
            jsonCompetitorEntries.add((Object)jsonCompetitor);
            JSONObject jsonRaceColumns = new JSONObject();
            jsonCompetitor.put((Object)"columns", (Object)jsonRaceColumns);
            for (String raceColumnName : raceColumnsToShow) {
                Map rankMap;
                Map rcMap;
                FleetDTO fleetOfCompetitor;
                JSONObject jsonEntry = new JSONObject();
                jsonRaceColumns.put((Object)raceColumnName, (Object)jsonEntry);
                LeaderboardEntryDTO leaderboardEntry = (LeaderboardEntryDTO)leaderboardRowDTO.fieldsByRaceColumnName.get(raceColumnName);
                if (leaderboardEntry == null) continue;
                BoatDTO entryBoatDTO = leaderboardEntry.boat;
                if (entryBoatDTO != null) {
                    JSONObject jsonBoat = new JSONObject();
                    this.writeBoatData(jsonBoat, entryBoatDTO, competitorAndBoatIdsOnly);
                    jsonEntry.put((Object)"boat", (Object)jsonBoat);
                }
                jsonEntry.put((Object)"fleet", (Object)((fleetOfCompetitor = leaderboardEntry.fleet) == null ? "" : fleetOfCompetitor.getName()));
                jsonEntry.put((Object)"totalPoints", (Object)leaderboardEntry.totalPoints);
                jsonEntry.put((Object)"uncorrectedTotalPoints", (Object)leaderboardEntry.totalPoints);
                jsonEntry.put((Object)"netPoints", (Object)leaderboardEntry.netPoints);
                MaxPointsReason maxPointsReason = leaderboardEntry.reasonForMaxPoints;
                jsonEntry.put((Object)"maxPointsReason", (Object)(maxPointsReason != null ? maxPointsReason.toString() : null));
                jsonEntry.put((Object)"isDiscarded", (Object)leaderboardEntry.discarded);
                jsonEntry.put((Object)"isCorrected", (Object)leaderboardEntry.hasScoreCorrection());
                Integer rank = null;
                if (fleetOfCompetitor != null && fleetOfCompetitor.getName() != null && (rcMap = (Map)competitorRanksPerRaceColumnsAndFleets.get(raceColumnName)) != null && !rcMap.isEmpty() && (rankMap = (Map)rcMap.get(fleetOfCompetitor.getName())) != null && !rankMap.isEmpty()) {
                    rank = (Integer)rankMap.get(competitor2);
                }
                jsonEntry.put((Object)"rank", rank);
                LegEntryDTO detailsOfLastAvailableLeg = this.getDetailsOfLastAvailableLeg(leaderboardEntry);
                jsonEntry.put((Object)"trackedRank", detailsOfLastAvailableLeg != null ? Integer.valueOf(detailsOfLastAvailableLeg.rank) : null);
                boolean finished = false;
                LegEntryDTO detailsOfLastCourseLeg = this.getDetailsOfLastCourseLeg(leaderboardEntry);
                if (detailsOfLastCourseLeg != null) {
                    finished = detailsOfLastCourseLeg.finished;
                }
                jsonEntry.put((Object)"finished", (Object)finished);
                if (raceDetailsToShow.isEmpty() || leaderboardEntry.race == null) continue;
                LegEntryDTO currentLegEntry = null;
                int currentLegNumber = leaderboardEntry.getOneBasedCurrentLegNumber();
                if (leaderboardEntry.legDetails != null && currentLegNumber > 0 && currentLegNumber <= leaderboardEntry.legDetails.size() && (currentLegEntry = (LegEntryDTO)leaderboardEntry.legDetails.get(currentLegNumber - 1)) != null) {
                    jsonEntry.put((Object)"trackedRank", (Object)currentLegEntry.rank);
                }
                JSONObject jsonRaceDetails = new JSONObject();
                jsonEntry.put((Object)"data", (Object)jsonRaceDetails);
                for (DetailType type : raceDetailsToShow) {
                    RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
                    DynamicCompetitor c = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitor2.getIdAsString());
                    TrackedRace trackedRace = c == null || raceColumn == null ? null : raceColumn.getTrackedRace((Competitor)c);
                    Util.Pair<String, Object> valueForRaceDetailType = this.getValueForRaceDetailType(leaderboard, type, leaderboardRowDTO, leaderboardEntry, currentLegEntry, trackedRace, raceColumn, (Competitor)c, (TimePoint)leaderboardTimePoint);
                    if (valueForRaceDetailType == null || valueForRaceDetailType.getA() == null || valueForRaceDetailType.getB() == null) continue;
                    jsonRaceDetails.put(valueForRaceDetailType.getA(), valueForRaceDetailType.getB());
                }
            }
            ++competitorCounter;
        }
        return jsonLeaderboard;
    }

    private boolean hasOverallDetail(List<DetailType> raceDetailsToShow) {
        HashSet availableOverallDetailTypeNames = new HashSet(Arrays.asList(this.getAvailableOverallDetailColumnTypes()).stream().collect(Collectors.toSet()));
        return availableOverallDetailTypeNames.removeAll(raceDetailsToShow);
    }

    private List<DetailType> calculateRaceDetailTypesToShow(List<String> raceDetailTypesNames) {
        List<Object> result = new ArrayList();
        if (raceDetailTypesNames.size() == 0) {
            result = Arrays.asList(this.getDefaultRaceDetailColumnTypes());
        } else if (raceDetailTypesNames.size() == 1 && raceDetailTypesNames.get(0).equals("ALL")) {
            result = Arrays.asList(this.getAvailableRaceDetailColumnTypes());
        } else {
            for (String raceDetailTypeName : raceDetailTypesNames) {
                DetailType value = DetailType.valueOf((String)raceDetailTypeName);
                if (!Arrays.asList(this.getAvailableRaceDetailColumnTypes()).contains(value)) {
                    throw new IllegalArgumentException(String.valueOf(raceDetailTypeName) + " is not a supported DetailType");
                }
                result.add(value);
            }
        }
        return result;
    }

    private DetailType[] getDefaultRaceDetailColumnTypes() {
        return new DetailType[]{DetailType.RACE_GAP_TO_LEADER_IN_SECONDS, DetailType.RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS, DetailType.RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS, DetailType.RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS, DetailType.RACE_CURRENT_LEG};
    }

    private DetailType[] getAvailableRaceDetailColumnTypes() {
        return new DetailType[]{DetailType.RACE_GAP_TO_LEADER_IN_SECONDS, DetailType.PERCENT_TARGET_BOAT_SPEED, DetailType.RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS, DetailType.RACE_DISTANCE_TRAVELED, DetailType.RACE_TIME_TRAVELED, DetailType.RACE_IMPLIED_WIND, DetailType.RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS, DetailType.RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES, DetailType.RACE_CURRENT_POSITION_LAT_DEG, DetailType.RACE_CURRENT_POSITION_LNG_DEG, DetailType.RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS, DetailType.NUMBER_OF_MANEUVERS, DetailType.RACE_CURRENT_LEG, DetailType.OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS, DetailType.LEG_VELOCITY_MADE_GOOD_IN_KNOTS, DetailType.LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS, DetailType.LEG_CURRENT_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS, DetailType.LEG_CURRENT_SIGNED_CROSS_TRACK_ERROR_IN_METERS, DetailType.LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS, DetailType.OVERALL_TIME_ON_TIME_FACTOR, DetailType.OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE};
    }

    private DetailType[] getAvailableOverallDetailColumnTypes() {
        return new DetailType[]{DetailType.OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS};
    }

    private Util.Pair<String, Object> getValueForRaceDetailType(Leaderboard leaderboard, DetailType type, LeaderboardRowDTO leaderboardRowDTO, LeaderboardEntryDTO entry, LegEntryDTO currentLegEntry, TrackedRace trackedRace, RaceColumn raceColumn, Competitor competitor, TimePoint timePoint) {
        Number value = null;
        Util.Pair result = null;
        if (type.getPremiumAction() == null || SecurityUtils.getSubject().isPermitted(SecuredDomainType.LEADERBOARD.getStringPermissionForObject(type.getPremiumAction(), (WithQualifiedObjectIdentifier)leaderboard))) {
            String name;
            switch (type) {
                case RACE_GAP_TO_LEADER_IN_SECONDS: {
                    name = "gapToLeader-s";
                    if (entry.gapToLeaderInOwnTime == null) break;
                    value = entry.gapToLeaderInOwnTime.asSeconds();
                    break;
                }
                case RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS: {
                    name = "gapToLeader-m";
                    if (entry.windwardDistanceToCompetitorFarthestAheadInMeters == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)entry.windwardDistanceToCompetitorFarthestAheadInMeters, (int)2);
                    break;
                }
                case RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS: {
                    name = "averageSpeedOverGround-kts";
                    Distance distance = entry.getDistanceTraveled();
                    Duration timeSailed = entry.getTimeSailed();
                    if (distance == null || timeSailed == null || timeSailed.compareTo((Object)Duration.NULL) <= 0) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)distance.inTime(timeSailed).getKnots(), (int)2);
                    break;
                }
                case RACE_DISTANCE_TRAVELED: {
                    name = "distanceTraveled-m";
                    Distance distanceTraveled = entry.getDistanceTraveled();
                    if (distanceTraveled == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)distanceTraveled.getMeters(), (int)2);
                    break;
                }
                case RACE_TIME_TRAVELED: {
                    name = "timeTraveled-s";
                    Duration timeTraveled = entry.getTimeSailed();
                    if (timeTraveled == null) break;
                    value = timeTraveled.asSeconds();
                    break;
                }
                case RACE_IMPLIED_WIND: {
                    name = "impliedWind-kts";
                    if (entry.impliedWind == null) break;
                    value = entry.impliedWind.getKnots();
                    break;
                }
                case RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS: {
                    name = "currentSpeedOverGround-kts";
                    if (entry.currentSpeedAndCourseOverGround == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)entry.currentSpeedAndCourseOverGround.getKnots(), (int)2);
                    break;
                }
                case RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES: {
                    name = "currentCourseOverGround-deg";
                    if (entry.currentSpeedAndCourseOverGround == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)entry.currentSpeedAndCourseOverGround.getBearing().getDegrees(), (int)2);
                    break;
                }
                case RACE_CURRENT_POSITION_LAT_DEG: {
                    Position position;
                    GPSFixTrack track;
                    name = "currentPositionLatitude-deg";
                    if (trackedRace == null || (track = trackedRace.getTrack(competitor)) == null || (position = track.getEstimatedPosition(timePoint, true)) == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)position.getLatDeg(), (int)10);
                    break;
                }
                case RACE_CURRENT_POSITION_LNG_DEG: {
                    Position position;
                    GPSFixTrack track;
                    name = "currentPositionLongitude-deg";
                    if (trackedRace == null || (track = trackedRace.getTrack(competitor)) == null || (position = track.getEstimatedPosition(timePoint, true)) == null) break;
                    value = LeaderboardsResourceV2.roundDouble((Double)position.getLngDeg(), (int)10);
                    break;
                }
                case NUMBER_OF_MANEUVERS: {
                    name = "numberOfManeuvers";
                    Integer numberOfManeuvers = null;
                    Map<ManeuverType, Integer> tacksJibesAndPenalties = this.getTotalNumberOfTacksJibesAndPenaltyCircles(entry);
                    for (Integer maneuverCount : tacksJibesAndPenalties.values()) {
                        if (maneuverCount == null) continue;
                        numberOfManeuvers = numberOfManeuvers == null ? maneuverCount : Integer.valueOf(numberOfManeuvers + maneuverCount);
                    }
                    value = numberOfManeuvers;
                    break;
                }
                case RACE_CURRENT_LEG: {
                    name = "currentLeg";
                    int currentLegNumber = entry.getOneBasedCurrentLegNumber();
                    if (currentLegNumber <= 0) break;
                    value = currentLegNumber;
                    break;
                }
                case OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS: {
                    name = "maxSpeedOverGroundInKnots";
                    value = leaderboardRowDTO.maximumSpeedOverGroundInKnots == null ? null : LeaderboardsResourceV2.roundDouble((Double)leaderboardRowDTO.maximumSpeedOverGroundInKnots, (int)2);
                    break;
                }
                case LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS: {
                    name = "legWindwardDistanceToGoInMeters";
                    if (currentLegEntry == null || currentLegEntry.windwardDistanceToGoInMeters == null) break;
                    value = currentLegEntry.windwardDistanceToGoInMeters;
                    break;
                }
                case LEG_VELOCITY_MADE_GOOD_IN_KNOTS: {
                    name = "legVelocityMadeGoodInKnots";
                    if (currentLegEntry == null || currentLegEntry.velocityMadeGoodInKnots == null) break;
                    value = currentLegEntry.velocityMadeGoodInKnots;
                    break;
                }
                case LEG_CURRENT_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS: {
                    name = "legCurrentAbsoluteCrossTrackErrorInMeters";
                    if (currentLegEntry == null || currentLegEntry.currentOrAverageAbsoluteCrossTrackErrorInMeters == null) break;
                    value = currentLegEntry.currentOrAverageAbsoluteCrossTrackErrorInMeters;
                    break;
                }
                case LEG_CURRENT_SIGNED_CROSS_TRACK_ERROR_IN_METERS: {
                    name = "legCurrentSignedCrossTrackErrorInMeters";
                    if (currentLegEntry == null || currentLegEntry.currentOrAverageSignedCrossTrackErrorInMeters == null) break;
                    value = currentLegEntry.currentOrAverageSignedCrossTrackErrorInMeters;
                    break;
                }
                case LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS: {
                    name = "currentLegAverageSpeedOverGround-kts";
                    if (currentLegEntry == null || currentLegEntry.averageSpeedOverGroundInKnots == null) break;
                    value = currentLegEntry.averageSpeedOverGroundInKnots;
                    break;
                }
                case OVERALL_TIME_ON_TIME_FACTOR: {
                    name = "timeOnTimeFactor";
                    value = leaderboardRowDTO.effectiveTimeOnTimeFactor;
                    break;
                }
                case OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE: {
                    name = "timeOnDistanceAllowanceInSecondsPerNauticalMile";
                    value = leaderboardRowDTO.effectiveTimeOnDistanceAllowancePerNauticalMile == null ? null : Double.valueOf(leaderboardRowDTO.effectiveTimeOnDistanceAllowancePerNauticalMile.asSeconds());
                    break;
                }
                default: {
                    name = null;
                }
            }
            if (name != null && value != null) {
                result = new Util.Pair((Object)name, (Object)value);
            }
        }
        return result;
    }

    private LegEntryDTO getDetailsOfLastCourseLeg(LeaderboardEntryDTO entry) {
        int lastLegIndex;
        LegEntryDTO lastLegDetail = null;
        if (entry != null && entry.legDetails != null && (lastLegIndex = entry.legDetails.size() - 1) >= 0) {
            lastLegDetail = (LegEntryDTO)entry.legDetails.get(lastLegIndex);
        }
        return lastLegDetail;
    }

    private LegEntryDTO getDetailsOfLastAvailableLeg(LeaderboardEntryDTO entry) {
        LegEntryDTO lastAvailableLegDetail = null;
        if (entry != null && entry.legDetails != null) {
            int i = entry.legDetails.size() - 1;
            while (i >= 0) {
                lastAvailableLegDetail = (LegEntryDTO)entry.legDetails.get(i);
                if (lastAvailableLegDetail != null) break;
                --i;
            }
        }
        return lastAvailableLegDetail;
    }

    private Map<ManeuverType, Integer> getTotalNumberOfTacksJibesAndPenaltyCircles(LeaderboardEntryDTO entry) {
        HashMap<ManeuverType, Integer> totalNumberOfManeuvers = new HashMap<ManeuverType, Integer>();
        ManeuverType[] maneuverTypeArray = new ManeuverType[]{ManeuverType.TACK, ManeuverType.JIBE, ManeuverType.PENALTY_CIRCLE};
        int n = maneuverTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverType maneuverType = maneuverTypeArray[n2];
            totalNumberOfManeuvers.put(maneuverType, 0);
            ++n2;
        }
        if (entry.legDetails != null) {
            for (LegEntryDTO legDetail : entry.legDetails) {
                if (legDetail == null) continue;
                ManeuverType[] maneuverTypeArray2 = new ManeuverType[]{ManeuverType.TACK, ManeuverType.JIBE, ManeuverType.PENALTY_CIRCLE};
                int n3 = maneuverTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManeuverType maneuverType = maneuverTypeArray2[n4];
                    if (legDetail.numberOfManeuvers != null && legDetail.numberOfManeuvers.get(maneuverType) != null) {
                        totalNumberOfManeuvers.put(maneuverType, (Integer)totalNumberOfManeuvers.get(maneuverType) + (Integer)legDetail.numberOfManeuvers.get(maneuverType));
                    }
                    ++n4;
                }
            }
        }
        return totalNumberOfManeuvers;
    }

    private List<String> calculateRaceColumnsToShow(Leaderboard leaderboard, List<String> raceColumnNames, Iterable<String> showOnlyActiveRacesForCompetitorIds, TimePoint resultTimePoint) {
        HashSet<String> raceColumnNamesAsSet = new HashSet<String>();
        if (raceColumnNames != null) {
            raceColumnNamesAsSet.addAll(raceColumnNames);
        }
        if (showOnlyActiveRacesForCompetitorIds != null) {
            Util.addAll(this.getRaceColumnNamesOfActiveRaceColumnsForCompetitorIds(showOnlyActiveRacesForCompetitorIds, leaderboard, resultTimePoint), raceColumnNamesAsSet);
        }
        ArrayList<String> raceColumnsToShow = new ArrayList<String>();
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            if ((!raceColumnNamesAsSet.isEmpty() || showOnlyActiveRacesForCompetitorIds != null && !Util.isEmpty(showOnlyActiveRacesForCompetitorIds)) && !raceColumnNamesAsSet.contains(raceColumn.getName())) continue;
            raceColumnsToShow.add(raceColumn.getName());
        }
        return raceColumnsToShow;
    }

    private Iterable<String> getRaceColumnNamesOfActiveRaceColumnsForCompetitorIds(Iterable<String> showOnlyActiveRacesForCompetitorIds, Leaderboard leaderboard, TimePoint timePoint) {
        HashSet<String> result = new HashSet<String>();
        for (String showOnlyActiveRacesForCompetitorId : showOnlyActiveRacesForCompetitorIds) {
            String nameOfActiveRaceColumnForCompetitor = this.getNameOfActiveRaceColumnForCompetitor(showOnlyActiveRacesForCompetitorId, leaderboard, timePoint);
            if (nameOfActiveRaceColumnForCompetitor == null) continue;
            result.add(nameOfActiveRaceColumnForCompetitor);
        }
        return result;
    }

    private String getNameOfActiveRaceColumnForCompetitor(String showOnlyActiveRacesForCompetitorId, Leaderboard leaderboard, TimePoint timePoint) {
        String result;
        TimePoint timePointOrLiveTimeIfNull = timePoint != null ? timePoint : leaderboard.getNowMinusDelay();
        Competitor competitor = leaderboard.getCompetitorByIdAsString(showOnlyActiveRacesForCompetitorId);
        if (competitor != null) {
            RaceColumn lastRaceColumnWithResultForCompetitorAtTimePoint = null;
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                if (leaderboard.getTotalPoints(competitor, raceColumn, timePointOrLiveTimeIfNull) == null) continue;
                lastRaceColumnWithResultForCompetitorAtTimePoint = raceColumn;
            }
            result = lastRaceColumnWithResultForCompetitorAtTimePoint != null ? lastRaceColumnWithResultForCompetitorAtTimePoint.getName() : null;
        } else {
            result = null;
        }
        return result;
    }
}

