/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneUUIDIdentifierImpl;
import com.sap.sailing.server.gateway.deserialization.impl.FlatSmartphoneUuidAndGPSFixMovingJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Duration;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/gps_fixes")
public class GPSFixesResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(GPSFixesResource.class.getName());
    private final JsonDeserializer<Util.Pair<UUID, List<GPSFixMoving>>> deserializer = new FlatSmartphoneUuidAndGPSFixMovingJsonDeserializer();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response postFixes(String json, @QueryParam(value="returnManeuverUpdate") @DefaultValue(value="false") Boolean returnManeuverUpdate, @QueryParam(value="returnLiveDelay") @DefaultValue(value="false") Boolean returnLiveDelay) {
        TimePoint received = MillisecondsTimePoint.now();
        Util.Pair data = null;
        try {
            logger.fine("Post issued to " + ((Object)((Object)this)).getClass().getName());
            Object requestBody = JSONValue.parseWithException((String)json);
            JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
            logger.fine("JSON requestObject is: " + requestObject.toString());
            data = (Util.Pair)this.deserializer.deserialize(requestObject);
        }
        catch (JsonDeserializationException | ParseException e) {
            logger.warning(String.format("Exception while parsing post request:\n%s", e.toString()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
        }
        SmartphoneUUIDIdentifierImpl device = new SmartphoneUUIDIdentifierImpl((UUID)data.getA());
        List fixes = (List)data.getB();
        JSONObject answer = new JSONObject();
        try {
            Iterable racesWithManeuverChangedAndLiveDelay = this.getService().getSensorFixStore().storeFixes((DeviceIdentifier)device, (Iterable)fixes, returnManeuverUpdate.booleanValue(), returnLiveDelay.booleanValue());
            if (!Util.isEmpty((Iterable)racesWithManeuverChangedAndLiveDelay)) {
                JSONArray changed = new JSONArray();
                answer.put((Object)"maneuverchanged", (Object)changed);
                for (Util.Triple raceWithManeuverChangedAndLiveDelay : racesWithManeuverChangedAndLiveDelay) {
                    JSONObject singleRaceRegatta = new JSONObject();
                    singleRaceRegatta.put((Object)"regattaName", (Object)((RegattaAndRaceIdentifier)raceWithManeuverChangedAndLiveDelay.getA()).getRegattaName());
                    singleRaceRegatta.put((Object)"raceName", (Object)((RegattaAndRaceIdentifier)raceWithManeuverChangedAndLiveDelay.getA()).getRaceName());
                    singleRaceRegatta.put((Object)"maneuverChanged", raceWithManeuverChangedAndLiveDelay.getB());
                    singleRaceRegatta.put((Object)"liveDelayInMillis", (Object)((Duration)raceWithManeuverChangedAndLiveDelay.getC()).asMillis());
                    changed.add((Object)singleRaceRegatta);
                }
            }
            logger.log(Level.INFO, "Added " + fixes.size() + " fixes for device " + device.toString() + " to store." + (fixes.isEmpty() ? "" : " Delay: " + ((GPSFixMoving)fixes.iterator().next()).getTimePoint().until(received)));
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.log(Level.WARNING, "Could not store fix for device " + device);
        }
        return Response.ok((Object)this.streamingOutput(answer)).build();
    }
}

