/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.EventBaseImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardGroupImpl;
import com.sap.sailing.domain.leaderboard.meta.LeaderboardGroupMetaLeaderboard;
import com.sap.sailing.geocoding.ReverseGeocoder;
import com.sap.sailing.server.gateway.jaxrs.exceptions.ExceptionManager;
import com.sap.sailing.server.gateway.serialization.impl.CourseAreaJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.EventBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.EventRaceStatesSerializer;
import com.sap.sailing.server.gateway.serialization.impl.LeaderboardGroupBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TrackingConnectorInfoJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.VenueJsonSerializer;
import com.sap.sailing.server.hierarchy.SailingHierarchyOwnershipUpdater;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AddColumnToSeries;
import com.sap.sailing.server.operationaltransformation.AddCourseAreas;
import com.sap.sailing.server.operationaltransformation.AddSpecificRegatta;
import com.sap.sailing.server.operationaltransformation.CreateEvent;
import com.sap.sailing.server.operationaltransformation.CreateLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.CreateRegattaLeaderboard;
import com.sap.sailing.server.operationaltransformation.RemoveEvent;
import com.sap.sailing.server.operationaltransformation.RemoveLeaderboard;
import com.sap.sailing.server.operationaltransformation.RemoveLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.RemoveRegatta;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardGroup;
import com.sap.sailing.server.operationaltransformation.UpdateSeries;
import com.sap.sailing.server.security.SailingViewerRole;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.WildcardPermissionEncoder;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

@Path(value="/v1/events")
public class EventsResource
extends AbstractSailingServerResource {
    public static final String V1_EVENTS = "/v1/events";
    private static final Logger logger = Logger.getLogger(EventsResource.class.getName());
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @DELETE
    @Path(value="/{eventId}/")
    public Response delete(@PathParam(value="eventId") String eventId, @QueryParam(value="withLeaderboardGroups") Boolean withLeaderboardGroups, @QueryParam(value="withLeaderboards") Boolean withLeaderboards, @QueryParam(value="withRegattas") Boolean withRegattas) throws java.text.ParseException {
        Serializable eventUUID = UUIDHelper.tryUuidConversion((Serializable)((Object)eventId));
        RacingEventService racingEventService = this.getService();
        Event event = racingEventService.getEvent(eventUUID);
        if (event == null) {
            return this.getBadEventErrorResponse(eventId);
        }
        boolean deleteLeaderboardGroups = withLeaderboardGroups == Boolean.TRUE;
        boolean deleteLeaderboards = withLeaderboards == Boolean.TRUE;
        boolean deleteRegattas = withRegattas == Boolean.TRUE;
        SecurityService securityService = this.getSecurityService();
        securityService.checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)event, () -> {
            racingEventService.apply((OperationWithResult)new RemoveEvent(event.getId()));
            if (deleteLeaderboards || deleteLeaderboardGroups || deleteRegattas) {
                for (LeaderboardGroup group : event.getLeaderboardGroups()) {
                    if (deleteLeaderboards || deleteRegattas) {
                        for (Leaderboard leaderboard : group.getLeaderboards()) {
                            if (deleteRegattas && leaderboard instanceof RegattaLeaderboard) {
                                this.deleteReferencedRegatta(securityService, racingEventService, leaderboard);
                            }
                            if (!deleteLeaderboards) continue;
                            securityService.checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)leaderboard, () -> racingEventService.apply((OperationWithResult)new RemoveLeaderboard(leaderboard.getName())));
                        }
                    }
                    if (!deleteLeaderboardGroups) continue;
                    securityService.checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)group, () -> {
                        if (!deleteLeaderboards) {
                            this.deleteReferencedOverallLeaderboard(deleteRegattas, securityService, racingEventService, group);
                        }
                        racingEventService.apply((OperationWithResult)new RemoveLeaderboardGroup(group.getId()));
                    });
                }
            }
        });
        return Response.ok().build();
    }

    private void deleteReferencedOverallLeaderboard(boolean deleteRegattas, SecurityService securityService, RacingEventService racingEventService, LeaderboardGroup group) {
        Leaderboard overallLeaderboard = group.getOverallLeaderboard();
        if (overallLeaderboard != null) {
            if (deleteRegattas && overallLeaderboard instanceof RegattaLeaderboard) {
                this.deleteReferencedRegatta(securityService, racingEventService, overallLeaderboard);
            }
            securityService.checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)overallLeaderboard, () -> racingEventService.apply((OperationWithResult)new RemoveLeaderboard(overallLeaderboard.getName())));
        }
    }

    private void deleteReferencedRegatta(SecurityService securityService, RacingEventService racingEventService, Leaderboard leaderboard) {
        RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
        Regatta regatta = regattaLeaderboard.getRegatta();
        securityService.checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)regatta, () -> racingEventService.apply((OperationWithResult)new RemoveRegatta(regatta.getRegattaIdentifier())));
    }

    @POST
    @Path(value="/{eventId}/migrate")
    public Response migrateOwnershipForEvent(@PathParam(value="eventId") UUID eventId, @QueryParam(value="createNewGroup") Boolean createNewGroup, @QueryParam(value="existingGroupId") UUID existingGroupIdOrNull, @QueryParam(value="newGroupName") String newGroupName, @QueryParam(value="migrateCompetitors") Boolean migrateCompetitors, @QueryParam(value="migrateBoats") Boolean migrateBoats, @QueryParam(value="copyMembersAndRoles") Boolean copyMembersAndRoles) throws java.text.ParseException, JsonDeserializationException {
        Event event = this.getService().getEvent((Serializable)eventId);
        SailingHierarchyOwnershipUpdater updater = SailingHierarchyOwnershipUpdater.createOwnershipUpdater((boolean)createNewGroup, (UUID)existingGroupIdOrNull, (String)newGroupName, (boolean)migrateCompetitors, (boolean)migrateBoats, (boolean)(copyMembersAndRoles == null ? true : copyMembersAndRoles), (RacingEventService)this.getService());
        updater.updateGroupOwnershipForEventHierarchy(event);
        return Response.ok().build();
    }

    @POST
    @Path(value="/createEvent")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createEvent(@Context UriInfo uriInfo, @FormParam(value="eventName") String eventNameParam, @FormParam(value="eventdescription") String eventDescriptionParam, @FormParam(value="startdate") String startDateParam, @FormParam(value="startdateasmillis") Long startDateAsMillis, @FormParam(value="enddate") String endDateParam, @FormParam(value="enddateasmillis") Long endDateAsMillis, @FormParam(value="venuename") String venueNameParam, @FormParam(value="venuelat") String venueLat, @FormParam(value="venuelng") String venueLng, @FormParam(value="ispublic") String isPublicParam, @FormParam(value="officialwebsiteurl") String officialWebsiteURLParam, @FormParam(value="baseurl") String baseURLParam, @FormParam(value="leaderboardgroupids") List<String> leaderboardGroupIdsListParam, @FormParam(value="createleaderboardgroup") String createLeaderboardGroupParam, @FormParam(value="createregatta") String createRegattaParam, @FormParam(value="boatclassname") String boatClassNameParam, @FormParam(value="numberofraces") String numberOfRacesParam, @FormParam(value="canBoatsOfCompetitorsChangePerRace") boolean canBoatsOfCompetitorsChangePerRace, @FormParam(value="competitorRegistrationType") String competitorRegistrationType, @FormParam(value="secret") String competitorRegistrationSecret, @FormParam(value="rankingMetric") String rankingMetricParam, @FormParam(value="scoringScheme") String scoringSchemeParam, @FormParam(value="leaderboardDiscardThresholds") List<Integer> leaderboardDiscardThresholdsParam) throws java.text.ParseException, NotFoundException, NumberFormatException, IOException, ParseException, InvalidDateException {
        Response response;
        if (venueNameParam == null && (venueLat == null || venueLng == null)) {
            response = this.createErrorResponse(Response.Status.PRECONDITION_FAILED, "No venue specified; provide either venuename or venuelat/venuelng", ErrorCodes.NO_VENUE);
        } else {
            Util.Triple<Event, LeaderboardGroup, RegattaLeaderboard> eventAndLeaderboardGroupAndLeaderboard = this.validateAndCreateEvent(uriInfo, eventNameParam, eventDescriptionParam, startDateParam, startDateAsMillis, endDateParam, endDateAsMillis, venueNameParam, venueLat, venueLng, isPublicParam, officialWebsiteURLParam, baseURLParam, leaderboardGroupIdsListParam, createLeaderboardGroupParam, createRegattaParam, boatClassNameParam, numberOfRacesParam, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, competitorRegistrationSecret, rankingMetricParam, scoringSchemeParam, leaderboardDiscardThresholdsParam);
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"eventid", (Object)((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getId().toString());
            jsonResponse.put((Object)"eventname", (Object)((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getName());
            jsonResponse.put((Object)"eventstartdate", ((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getStartDate() == null ? null : Long.valueOf(((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getStartDate().asMillis()));
            jsonResponse.put((Object)"eventenddate", ((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getEndDate() == null ? null : Long.valueOf(((Event)eventAndLeaderboardGroupAndLeaderboard.getA()).getEndDate().asMillis()));
            if (eventAndLeaderboardGroupAndLeaderboard.getB() != null) {
                jsonResponse.put((Object)"leaderboardgroupid", (Object)((LeaderboardGroup)eventAndLeaderboardGroupAndLeaderboard.getB()).getId().toString());
            }
            if (eventAndLeaderboardGroupAndLeaderboard.getC() != null) {
                jsonResponse.put((Object)"regatta", (Object)((RegattaLeaderboard)eventAndLeaderboardGroupAndLeaderboard.getC()).getRegatta().getName());
                jsonResponse.put((Object)"registrationSecret", (Object)((RegattaLeaderboard)eventAndLeaderboardGroupAndLeaderboard.getC()).getRegatta().getRegistrationLinkSecret());
                jsonResponse.put((Object)"leaderboard", (Object)((RegattaLeaderboard)eventAndLeaderboardGroupAndLeaderboard.getC()).getName());
            }
            response = Response.ok((Object)this.streamingOutput(jsonResponse)).build();
        }
        return response;
    }

    private Response createErrorResponse(Response.Status responseStatus, String message, ErrorCodes errorCode) {
        JSONObject responseBody = new JSONObject();
        responseBody.put((Object)"message", (Object)message);
        responseBody.put((Object)"errorCodeName", (Object)errorCode.name());
        responseBody.put((Object)"errorCode", (Object)errorCode.getErrorCode());
        return Response.status((Response.Status)responseStatus).entity((Object)responseBody.toString()).build();
    }

    @PUT
    @Path(value="/{eventId}/update")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateEvent(@Context UriInfo uriInfo, @PathParam(value="eventId") String eventId, @FormParam(value="eventName") String eventNameParam, @FormParam(value="eventdescription") String eventDescriptionParam, @FormParam(value="startdate") String startDateParam, @FormParam(value="startdateasmillis") Long startDateAsMillis, @FormParam(value="enddate") String endDateParam, @FormParam(value="enddateasmillis") Long endDateAsMillis, @FormParam(value="venuename") String venueNameParam, @FormParam(value="venuelat") String venueLat, @FormParam(value="venuelng") String venueLng, @FormParam(value="ispublic") String isPublicParam, @FormParam(value="officialwebsiteurl") String officialWebsiteURLParam, @FormParam(value="baseurl") String baseURLParam, @FormParam(value="leaderboardgroupids") List<String> leaderboardGroupIdsListParam, @FormParam(value="createleaderboardgroup") String createLeaderboardGroupParam, @FormParam(value="createregatta") String createRegattaParam, @FormParam(value="boatclassname") String boatClassNameParam, @FormParam(value="numberofraces") String numberOfRacesParam) throws java.text.ParseException, NotFoundException, NumberFormatException, IOException, ParseException, InvalidDateException {
        Response response;
        UUID id;
        try {
            id = this.toUUID(eventId);
        }
        catch (IllegalArgumentException e) {
            return this.getBadEventErrorResponse(eventId);
        }
        Event event = this.getService().getEvent((Serializable)id);
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.EVENT.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)event));
        if (event == null) {
            response = this.getBadEventErrorResponse(eventId);
        } else {
            boolean isPublic;
            String eventName = eventNameParam != null ? eventNameParam : event.getName();
            String eventDescription = eventDescriptionParam != null ? eventDescriptionParam : event.getDescription();
            TimePoint startDate = startDateParam != null || startDateAsMillis != null ? this.parseTimePoint(startDateParam, startDateAsMillis, null) : event.getStartDate();
            TimePoint endDate = endDateParam != null || endDateAsMillis != null ? this.parseTimePoint(endDateParam, endDateAsMillis, null) : event.getEndDate();
            String venueName = venueNameParam != null ? venueNameParam : (venueLat != null && venueLng != null ? this.getDefaultVenueName(venueLat, venueLng) : event.getVenue().getName());
            boolean bl = isPublic = isPublicParam != null ? Boolean.valueOf(isPublicParam).booleanValue() : event.isPublic();
            List<Object> leaderboardGroupIds = leaderboardGroupIdsListParam.isEmpty() ? Util.map((Iterable)event.getLeaderboardGroups(), lg -> lg.getId()) : (leaderboardGroupIdsListParam.size() == 1 && leaderboardGroupIdsListParam.get(0).isEmpty() ? Collections.emptyList() : this.toUUIDList(leaderboardGroupIdsListParam));
            URL officialWebsiteURL = officialWebsiteURLParam != null ? new URL(officialWebsiteURLParam) : event.getOfficialWebsiteURL();
            URL baseURL = baseURLParam != null ? new URL(baseURLParam) : event.getBaseURL();
            this.getService().updateEvent(id, eventName, eventDescription, startDate, endDate, venueName, isPublic, leaderboardGroupIds, officialWebsiteURL, baseURL, event.getSailorsInfoWebsiteURLs(), event.getImages(), event.getVideos(), event.getWindFinderReviewedSpotsCollectionIds());
            response = Response.ok().build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getEvents(@QueryParam(value="showNonPublic") String showNonPublic, @QueryParam(value="include") @DefaultValue(value="false") Boolean include, @QueryParam(value="id") List<UUID> eventIds) {
        EventBaseJsonSerializer eventSerializer = new EventBaseJsonSerializer((JsonSerializer)new VenueJsonSerializer((JsonSerializer)new CourseAreaJsonSerializer()), (JsonSerializer)new LeaderboardGroupBaseJsonSerializer(), (JsonSerializer)new TrackingConnectorInfoJsonSerializer());
        JSONArray result = new JSONArray();
        Iterable events = this.getService().getEventsSelectively(include.booleanValue(), eventIds);
        for (Event event : events) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event) || (showNonPublic == null || !Boolean.valueOf(showNonPublic).booleanValue()) && !event.isPublic()) continue;
            result.add((Object)eventSerializer.serialize((Object)event));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{eventId}")
    public Response getEvent(@PathParam(value="eventId") String eventId, @QueryParam(value="secret") String secret) {
        Response response;
        UUID eventUuid;
        try {
            eventUuid = this.toUUID(eventId);
        }
        catch (IllegalArgumentException e) {
            return this.getBadEventErrorResponse(eventId);
        }
        Event event = this.getService().getEvent((Serializable)eventUuid);
        if (event == null) {
            response = this.getBadEventErrorResponse(eventId);
        } else {
            boolean skip = false;
            for (LeaderboardGroup lg : event.getLeaderboardGroups()) {
                for (Leaderboard l : lg.getLeaderboards()) {
                    if (!this.getService().skipChecksDueToCorrectSecret(l.getName(), secret)) continue;
                    skip = true;
                }
            }
            if (!skip) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
            }
            EventBaseJsonSerializer eventSerializer = new EventBaseJsonSerializer((JsonSerializer)new VenueJsonSerializer((JsonSerializer)new CourseAreaJsonSerializer()), (JsonSerializer)new LeaderboardGroupBaseJsonSerializer(), (JsonSerializer)new TrackingConnectorInfoJsonSerializer());
            JSONObject eventJson = eventSerializer.serialize((Object)event);
            response = Response.ok((Object)this.streamingOutput(eventJson)).build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{eventId}/racestates")
    public Response getRaceStates(@PathParam(value="eventId") String eventId, @QueryParam(value="filterByLeaderboard") String filterByLeaderboard, @QueryParam(value="filterByCourseArea") String filterByCourseArea, @QueryParam(value="filterByDayOffset") String filterByDayOffset, @QueryParam(value="clientTimeZoneOffsetInMinutes") Integer clientTimeZoneOffsetInMinutes) {
        Response response;
        UUID eventUuid;
        try {
            eventUuid = this.toUUID(eventId);
        }
        catch (IllegalArgumentException e) {
            return this.getBadEventErrorResponse(eventId);
        }
        Event event = this.getService().getEvent((Serializable)eventUuid);
        if (event == null) {
            response = this.getBadEventErrorResponse(eventId);
        } else if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) {
            Object clientTimeZoneOffset = filterByDayOffset != null ? (clientTimeZoneOffsetInMinutes != null ? new MillisecondsDurationImpl((long)(60000 * clientTimeZoneOffsetInMinutes)) : Duration.NULL) : null;
            EventRaceStatesSerializer eventRaceStatesSerializer = new EventRaceStatesSerializer(filterByCourseArea, filterByLeaderboard, filterByDayOffset, clientTimeZoneOffset, (RaceLogResolver)this.getService());
            JSONObject raceStatesJson = eventRaceStatesSerializer.serialize(new Util.Pair((Object)event, this.getService().getLeaderboards().values()));
            response = Response.ok((Object)this.streamingOutput(raceStatesJson)).build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }

    private RegattaLeaderboard validateAndCreateRegatta(String regattaNameParam, String boatClassNameParam, String scoringSchemeParam, final UUID courseAreaId, String buoyZoneRadiusInHullLengthsParam, String useStartTimeInterferenceParam, String controlTrackingFromStartAndFinishTimesParam, String autoRestartTrackingUponCompetitorSetChangeParam, String rankingMetricParam, List<Integer> leaderboardDiscardThresholdsParam, String numberOfRacesParam, final boolean canBoatsOfCompetitorsChangePerRace, final CompetitorRegistrationType competitorRegistrationType, final String competitorRegistrationSecret) throws java.text.ParseException, NotFoundException {
        double buoyZoneRadiusInHullLengths;
        final boolean controlTrackingFromStartAndFinishTimes = controlTrackingFromStartAndFinishTimesParam == null ? false : Boolean.parseBoolean(controlTrackingFromStartAndFinishTimesParam);
        final boolean autoRestartTrackingUponCompetitorSetChange = autoRestartTrackingUponCompetitorSetChangeParam == null ? false : Boolean.parseBoolean(autoRestartTrackingUponCompetitorSetChangeParam);
        final boolean useStartTimeInterference = useStartTimeInterferenceParam == null ? true : Boolean.parseBoolean(useStartTimeInterferenceParam);
        double d = buoyZoneRadiusInHullLengths = buoyZoneRadiusInHullLengthsParam == null ? 3.0 : Double.parseDouble(buoyZoneRadiusInHullLengthsParam);
        if (regattaNameParam == null) {
            throw new IllegalArgumentException(ExceptionManager.parameterRequiredMsg("regattaName"));
        }
        if (competitorRegistrationSecret == null) {
            throw new IllegalArgumentException(ExceptionManager.parameterRequiredMsg("competitorRegistrationSecret"));
        }
        if (boatClassNameParam == null) {
            throw new IllegalArgumentException(ExceptionManager.parameterRequiredMsg("boatClassName"));
        }
        final String regattaName = regattaNameParam;
        final String boatClassName = boatClassNameParam;
        final ScoringScheme scoringScheme = scoringSchemeParam == null ? this.createScoringScheme("LOW_POINT") : this.createScoringScheme(scoringSchemeParam);
        final RankingMetrics rankingMetric = rankingMetricParam == null ? this.createRankingMetric("ONE_DESIGN") : this.createRankingMetric(rankingMetricParam);
        int[] leaderboardDiscardThresholds = leaderboardDiscardThresholdsParam == null ? new int[]{} : leaderboardDiscardThresholdsParam.stream().mapToInt(i -> i).toArray();
        int numberOfRaces = numberOfRacesParam == null ? 0 : Integer.parseInt(numberOfRacesParam);
        final RegattaCreationParametersDTO regattaCreationParametersDTO = new RegattaCreationParametersDTO(this.createDefaultSeriesCreationParameters(regattaName, numberOfRaces));
        final UUID regattaId = UUID.randomUUID();
        Regatta regatta = (Regatta)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.REGATTA, Regatta.getTypeRelativeObjectIdentifier((String)regattaName), regattaName, (Callable)new Callable<Regatta>(){

            @Override
            public Regatta call() throws Exception {
                return (Regatta)EventsResource.this.getService().apply((OperationWithResult)new AddSpecificRegatta(regattaName, boatClassName, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, competitorRegistrationSecret, null, null, (Serializable)regattaId, regattaCreationParametersDTO, true, scoringScheme, courseAreaId == null ? Collections.emptySet() : Collections.singleton(courseAreaId), Double.valueOf(buoyZoneRadiusInHullLengths), useStartTimeInterference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetric));
            }
        });
        RegattaLeaderboard leaderboard = this.addLeaderboard(regattaName, leaderboardDiscardThresholds);
        SeriesCreationParametersDTO defaultSeries = (SeriesCreationParametersDTO)regattaCreationParametersDTO.getSeriesCreationParameters().get("Default");
        this.addRaceColumns(regattaName, "Default", numberOfRaces);
        this.updateSeries(regatta, defaultSeries);
        return leaderboard;
    }

    private Util.Triple<Event, LeaderboardGroup, RegattaLeaderboard> validateAndCreateEvent(UriInfo uriInfo, String eventNameParam, String eventDescriptionParam, String startDateParam, Long startDateAsMillis, String endDateParam, Long endDateAsMillis, String venueNameParam, String venueLat, String venueLng, String isPublicParam, String officialWebsiteURLParam, String baseURLParam, List<String> leaderboardGroupIdsListParam, String createLeaderboardGroupParam, String createRegattaParam, final String boatClassName, final String numberOfRacesParam, final boolean canBoatsOfCompetitorsChangePerRace, String competitorRegistrationTypeString, final String competitorRegistrationSecret, final String rankingMetric, final String scoringScheme, final List<Integer> leaderboardDiscardThresholdsParam) throws java.text.ParseException, NotFoundException, NumberFormatException, IOException, ParseException, InvalidDateException {
        CompetitorRegistrationType competitorRegistrationType;
        final boolean isPublic = isPublicParam == null ? false : Boolean.parseBoolean(isPublicParam);
        final boolean createRegatta = createRegattaParam == null ? true : Boolean.parseBoolean(createRegattaParam);
        final boolean createLeaderboardGroup = createLeaderboardGroupParam == null ? true : Boolean.parseBoolean(createLeaderboardGroupParam);
        final String eventName = eventNameParam == null ? this.getDefaultEventName() : eventNameParam;
        final String venueName = venueNameParam == null ? this.getDefaultVenueName(venueLat, venueLng) : venueNameParam;
        final String leaderboardGroupName = eventName;
        final String regattaAndLeaderboardName = eventName;
        if (createRegatta && boatClassName == null) {
            throw new WebApplicationException(this.createErrorResponse(Response.Status.BAD_REQUEST, ExceptionManager.parameterRequiredMsg("boatClassName"), ErrorCodes.NO_BOAT_CLASS));
        }
        if (createLeaderboardGroup && this.getService().getLeaderboardGroupByName(leaderboardGroupName) != null) {
            throw new WebApplicationException(this.createErrorResponse(Response.Status.BAD_REQUEST, ExceptionManager.objectAlreadyExists("leaderboard group", leaderboardGroupName), ErrorCodes.LEADERBOARD_GROUP_ALREADY_EXISTS));
        }
        if (createRegatta) {
            if (this.getService().getRegattaByName(regattaAndLeaderboardName) != null) {
                throw new WebApplicationException(this.createErrorResponse(Response.Status.BAD_REQUEST, ExceptionManager.objectAlreadyExists("regatta", regattaAndLeaderboardName), ErrorCodes.REGATTA_ALREADY_EXISTS));
            }
            if (this.getService().getLeaderboardByName(regattaAndLeaderboardName) != null) {
                throw new WebApplicationException(this.createErrorResponse(Response.Status.BAD_REQUEST, ExceptionManager.objectAlreadyExists("leaderboard", regattaAndLeaderboardName), ErrorCodes.LEADERBOARD_ALREADY_EXISTS));
            }
        }
        final String eventDescription = eventDescriptionParam == null ? eventName : eventDescriptionParam;
        final TimePoint startDate = this.parseTimePoint(startDateParam, startDateAsMillis, (TimePoint)this.now());
        final TimePoint endDate = this.parseTimePoint(endDateParam, endDateAsMillis, (TimePoint)new MillisecondsTimePoint(this.addOneWeek(startDate.asDate())));
        final URL officialWebsiteURL = officialWebsiteURLParam == null ? null : this.toURL(officialWebsiteURLParam);
        URI baseUri = uriInfo.getBaseUri();
        int port = baseUri.getPort();
        String scheme = port >= 0 && port != 443 ? "http" : "https";
        final URL baseURL = baseURLParam == null ? new URL(String.valueOf(scheme) + ":" + baseUri.getSchemeSpecificPart().substring(0, baseUri.getSchemeSpecificPart().length() - baseUri.getPath().length())) : this.toURL(baseURLParam);
        final List<Object> leaderboardGroupIds = leaderboardGroupIdsListParam == null ? new ArrayList() : this.toUUIDList(leaderboardGroupIdsListParam);
        final UUID eventId = UUID.randomUUID();
        final HashMap sailorsInfoWebsiteURLs = new HashMap();
        final List images = Collections.emptyList();
        final List videos = Collections.emptyList();
        try {
            competitorRegistrationType = CompetitorRegistrationType.valueOfOrDefault((String)competitorRegistrationTypeString, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(ExceptionManager.incorrectParameterValue(competitorRegistrationTypeString, StringUtils.join((Object[])CompetitorRegistrationType.values(), (String)", ")));
        }
        Callable<Util.Triple<Event, LeaderboardGroup, RegattaLeaderboard>> doCreationAction = new Callable<Util.Triple<Event, LeaderboardGroup, RegattaLeaderboard>>(){

            @Override
            public Util.Triple<Event, LeaderboardGroup, RegattaLeaderboard> call() throws Exception {
                RegattaLeaderboard leaderboard;
                logger.info("User " + SecurityUtils.getSubject().getPrincipal() + " is trying to create event " + eventName);
                Event event = (Event)EventsResource.this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.EVENT, EventBaseImpl.getTypeRelativeObjectIdentifier((UUID)eventId), eventName, () -> (Event)EventsResource.this.getService().apply((OperationWithResult)new CreateEvent(eventName, eventDescription, startDate, endDate, venueName, isPublic, eventId, officialWebsiteURL, baseURL, sailorsInfoWebsiteURLs, images, videos, (Iterable)leaderboardGroupIds)));
                CourseArea courseArea = EventsResource.this.addCourseArea(event, "Default");
                LeaderboardGroup leaderboardGroup = createLeaderboardGroup ? EventsResource.this.validateAndAddLeaderboardGroup(event.getId(), leaderboardGroupName, event.getDescription(), null, false, null, null, null) : null;
                if (createRegatta) {
                    String localCompetitorRegistrationSecret = competitorRegistrationSecret;
                    if (localCompetitorRegistrationSecret == null) {
                        localCompetitorRegistrationSecret = UUID.randomUUID().toString();
                        logger.warning("Got request that created a new Regatta without a registrationSecret, generated a new one");
                    }
                    leaderboard = EventsResource.this.validateAndCreateRegatta(regattaAndLeaderboardName, boatClassName, scoringScheme, courseArea.getId(), null, null, null, null, rankingMetric, leaderboardDiscardThresholdsParam, numberOfRacesParam, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, localCompetitorRegistrationSecret);
                    if (leaderboardGroup != null) {
                        EventsResource.this.getService().apply((OperationWithResult)new UpdateLeaderboardGroup(leaderboardGroup.getId(), leaderboardGroup.getName(), leaderboardGroup.getDescription(), leaderboardGroup.getDisplayName(), Collections.singletonList(leaderboard.getName()), leaderboardGroup.getOverallLeaderboard() == null ? null : ((ThresholdBasedResultDiscardingRule)leaderboardGroup.getOverallLeaderboard().getResultDiscardingRule()).getDiscardIndexResultsStartingWithHowManyRaces(), leaderboardGroup.getOverallLeaderboard() == null ? null : leaderboardGroup.getOverallLeaderboard().getScoringScheme().getType()));
                    }
                } else {
                    leaderboard = null;
                }
                return new Util.Triple((Object)event, leaderboardGroup, leaderboard);
            }
        };
        try {
            if (competitorRegistrationType == CompetitorRegistrationType.OPEN_UNMODERATED) {
                UUID newTenantId = UUID.randomUUID();
                String escapedName = String.valueOf(WildcardPermissionEncoder.encode((String[])new String[]{eventName})) + "-owner";
                UserGroup ownerGroup = this.getSecurityService().createUserGroup(newTenantId, escapedName);
                this.getSecurityService().setDefaultOwnershipIfNotSet(ownerGroup.getIdentifier());
                RoleDefinition roleDef = this.getSecurityService().getRoleDefinition(SailingViewerRole.getInstance().getId());
                this.getSecurityService().putRoleDefinitionToUserGroup(ownerGroup, roleDef, true);
                this.getSecurityService().addUserToUserGroup(ownerGroup, this.getCurrentUser());
                return (Util.Triple)this.getSecurityService().doWithTemporaryDefaultTenant(ownerGroup, (Callable)doCreationAction);
            }
            return (Util.Triple)doCreationAction.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LeaderboardGroup validateAndAddLeaderboardGroup(UUID eventId, String leaderboardGroupName, String leaderboardGroupDescription, String leaderboardGroupDisplayName, boolean displayGroupsInReverseOrder, List<String> leaderboardNamesParam, List<Integer> overallLeaderboardDiscardThresholdsParam, String overallLeaderboardScoringSchemeTypeParam) throws NotFoundException {
        LeaderboardGroup leaderboardGroup;
        UUID leaderboardGroupId = UUID.randomUUID();
        ScoringSchemeType overallLeaderboardScoringSchemeType = overallLeaderboardScoringSchemeTypeParam == null ? null : this.getScoringSchemeType(overallLeaderboardScoringSchemeTypeParam);
        Callable<LeaderboardGroup> createLeaderboardGroup = () -> {
            int[] overallLeaderboardDiscardThresholds = overallLeaderboardDiscardThresholdsParam == null ? new int[]{} : overallLeaderboardDiscardThresholdsParam.stream().mapToInt(i -> i).toArray();
            List leaderboardNames = leaderboardNamesParam == null ? new ArrayList() : leaderboardNamesParam;
            return (LeaderboardGroup)this.getService().apply((OperationWithResult)new CreateLeaderboardGroup(leaderboardGroupId, leaderboardGroupName, leaderboardGroupDescription, leaderboardGroupDisplayName, displayGroupsInReverseOrder, leaderboardNames, overallLeaderboardDiscardThresholds, overallLeaderboardScoringSchemeType));
        };
        if (overallLeaderboardScoringSchemeType != null) {
            String overallLeaderboardName = LeaderboardGroupMetaLeaderboard.getOverallLeaderboardName((String)leaderboardGroupName);
            leaderboardGroup = (LeaderboardGroup)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, new TypeRelativeObjectIdentifier(new String[]{overallLeaderboardName}), overallLeaderboardName, () -> (LeaderboardGroup)createLeaderboardGroup.call());
        } else {
            leaderboardGroup = (LeaderboardGroup)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD_GROUP, LeaderboardGroupImpl.getTypeRelativeObjectIdentifier((UUID)leaderboardGroupId), leaderboardGroupName, createLeaderboardGroup);
        }
        this.updateEvent(this.getEvent(eventId), leaderboardGroup);
        return leaderboardGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultEventName() {
        String username = this.getCurrentUser().getName();
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        synchronized (simpleDateFormat) {
            return "Session " + username + " " + dateTimeFormat.format(new Date());
        }
    }

    private User getCurrentUser() {
        return this.getSecurityService().getCurrentUser();
    }

    private String getDefaultVenueName(String lat, String lng) throws NumberFormatException, IOException, ParseException {
        return ReverseGeocoder.INSTANCE.getPlacemarkNearest((Position)new DegreePosition(Double.valueOf(lat).doubleValue(), Double.valueOf(lng).doubleValue())).getName();
    }

    private void updateSeries(Regatta regatta, SeriesCreationParametersDTO defaultSeries) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        this.getService().apply((OperationWithResult)new UpdateSeries((RegattaIdentifier)new RegattaName(regatta.getName()), "Default", "Default", defaultSeries.isMedal(), defaultSeries.isFleetsCanRunInParallel(), defaultSeries.getDiscardingThresholds(), defaultSeries.isStartsWithZero(), defaultSeries.isFirstColumnIsNonDiscardableCarryForward(), defaultSeries.hasSplitFleetContiguousScoring(), defaultSeries.hasCrossFleetMergedRanking(), defaultSeries.getMaximumNumberOfDiscards(), defaultSeries.isOneAlwaysStaysOne(), defaultSeries.getFleets()));
    }

    private void addRaceColumns(String regattaName, String seriesName, int numberOfRaces) {
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            throw new IllegalArgumentException(ExceptionManager.objectNotFoundMsg("regatta", regattaName));
        }
        int oneBasedNumberOfNextRace = Util.size((Iterable)regatta.getRaceColumns()) + 1;
        int i = 1;
        while (i <= numberOfRaces) {
            this.addRaceColumn(regatta, seriesName, "R" + oneBasedNumberOfNextRace++);
            ++i;
        }
    }

    private RaceColumnInSeries addRaceColumn(Regatta regatta, String seriesName, String columnName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.REGATTA.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)regatta));
        return (RaceColumnInSeries)this.getService().apply((OperationWithResult)new AddColumnToSeries((RegattaIdentifier)new RegattaName(regatta.getName()), seriesName, columnName));
    }

    private void updateEvent(Event event, LeaderboardGroup leaderboardGroup) {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)event);
        ArrayList<UUID> newLeaderboardGroupIds = new ArrayList<UUID>();
        StreamSupport.stream(event.getLeaderboardGroups().spliterator(), false).forEach(lg -> {
            boolean bl = newLeaderboardGroupIds.add(lg.getId());
        });
        newLeaderboardGroupIds.add(leaderboardGroup.getId());
        this.getService().updateEvent(event.getId(), event.getName(), event.getDescription(), event.getStartDate(), event.getEndDate(), event.getVenue().getName(), event.isPublic(), newLeaderboardGroupIds, event.getOfficialWebsiteURL(), event.getBaseURL(), event.getSailorsInfoWebsiteURLs(), event.getImages(), event.getVideos(), event.getWindFinderReviewedSpotsCollectionIds());
    }

    private CourseArea addCourseArea(Event event, String courseAreaName) {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.EVENT.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)event));
        String[] courseAreaNames = new String[]{courseAreaName};
        UUID[] courseAreaIds = new UUID[]{UUID.randomUUID()};
        CourseArea[] courseAreas = (CourseArea[])this.getService().apply((OperationWithResult)new AddCourseAreas(event.getId(), courseAreaNames, courseAreaIds, new Position[1], new Distance[1]));
        return courseAreas[0];
    }

    private void addLeaderboardToDefaultLeaderboardGroup(RegattaLeaderboard leaderboard) {
        LeaderboardGroup defaultLeaderboardGroup = null;
        for (Event event : this.getService().getAllEvents()) {
            Iterable courseAreas = event.getVenue().getCourseAreas();
            for (CourseArea courseArea : courseAreas) {
                if (!Util.contains((Iterable)leaderboard.getRegatta().getCourseAreas(), (Object)courseArea.getId())) continue;
                for (LeaderboardGroup lg2 : event.getLeaderboardGroups()) {
                    if (!lg2.getName().equals(event.getName())) continue;
                    defaultLeaderboardGroup = lg2;
                }
            }
        }
        if (defaultLeaderboardGroup != null) {
            defaultLeaderboardGroup.addLeaderboard((Leaderboard)leaderboard);
            List leaderboards = this.stream(defaultLeaderboardGroup.getLeaderboards().spliterator()).map(lg -> lg.getName()).collect(Collectors.toList());
            ResultDiscardingRule rule = defaultLeaderboardGroup.getOverallLeaderboard() == null ? null : defaultLeaderboardGroup.getOverallLeaderboard().getResultDiscardingRule();
            int[] overallLeaderboardDiscardThresholds = null;
            if (rule instanceof ThresholdBasedResultDiscardingRule) {
                ThresholdBasedResultDiscardingRule resultDiscardingRule = (ThresholdBasedResultDiscardingRule)rule;
                overallLeaderboardDiscardThresholds = resultDiscardingRule.getDiscardIndexResultsStartingWithHowManyRaces();
            }
            this.getService().updateLeaderboardGroup(defaultLeaderboardGroup.getId(), defaultLeaderboardGroup.getName(), defaultLeaderboardGroup.getDescription(), defaultLeaderboardGroup.getDisplayName(), leaderboards, overallLeaderboardDiscardThresholds, defaultLeaderboardGroup.getOverallLeaderboard() == null ? null : defaultLeaderboardGroup.getOverallLeaderboard().getScoringScheme().getType());
        }
    }

    private RegattaLeaderboard addLeaderboard(String regattaName, int[] discardThresholds) {
        RegattaLeaderboard leaderboard = null;
        leaderboard = this.createRegattaLeaderboard(regattaName, discardThresholds);
        this.addLeaderboardToDefaultLeaderboardGroup(leaderboard);
        return leaderboard;
    }

    private RegattaLeaderboard createRegattaLeaderboard(final String regattaName, final int[] discardThresholds) {
        return (RegattaLeaderboard)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.LEADERBOARD, Leaderboard.getTypeRelativeObjectIdentifier((String)regattaName), regattaName, (Callable)new Callable<RegattaLeaderboard>(){

            @Override
            public RegattaLeaderboard call() throws Exception {
                return (RegattaLeaderboard)EventsResource.this.getService().apply((OperationWithResult)new CreateRegattaLeaderboard((RegattaIdentifier)new RegattaName(regattaName), regattaName, discardThresholds));
            }
        });
    }

    private Response getBadEventErrorResponse(String eventId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find an event with id '" + StringEscapeUtils.escapeHtml((String)eventId) + "'.")).type("text/plain").build();
    }

    private MillisecondsTimePoint now() {
        return new MillisecondsTimePoint(new Date());
    }

    private Date addOneWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(4, 1);
        return c.getTime();
    }

    private URL toURL(String url) throws MalformedURLException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(ExceptionManager.invalidURLFormatMsg(url));
        }
    }

    private List<UUID> toUUIDList(List<String> list) {
        return list.stream().map(id -> this.toUUID((String)id)).collect(Collectors.toList());
    }

    private UUID toUUID(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ExceptionManager.invalidIdFormatMsg(id));
        }
    }

    private LinkedHashMap<String, SeriesCreationParametersDTO> createDefaultSeriesCreationParameters(String regattaName, int numberOfRaces) {
        LinkedHashMap<String, SeriesCreationParametersDTO> series = new LinkedHashMap<String, SeriesCreationParametersDTO>();
        series.put("Default", new SeriesCreationParametersDTO(Arrays.asList(new FleetDTO("Default", 0, null)), false, false, false, false, null, false, false, null, false));
        return series;
    }

    private RankingMetrics createRankingMetric(String rankingMetricParam) {
        try {
            return RankingMetrics.valueOf((String)rankingMetricParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ExceptionManager.incorrectParameterValue(rankingMetricParam, this.getEnumValuesAsString(RankingMetrics.class)));
        }
    }

    private ScoringScheme createScoringScheme(String scoringSchemeParam) {
        ScoringScheme scoringScheme = this.getService().getBaseDomainFactory().createScoringScheme(this.getScoringSchemeType(scoringSchemeParam));
        return scoringScheme;
    }

    private <E extends Enum<E>> String getEnumValuesAsString(Class<E> e) {
        return EnumSet.allOf(e).stream().map(en -> en.name()).collect(Collectors.joining(", "));
    }

    private ScoringSchemeType getScoringSchemeType(String scoringSchemeTypeParam) {
        try {
            return ScoringSchemeType.valueOf((String)scoringSchemeTypeParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ExceptionManager.incorrectParameterValue(scoringSchemeTypeParam, this.getEnumValuesAsString(ScoringSchemeType.class)));
        }
    }

    private Event getEvent(UUID eventId) throws NotFoundException {
        Event event = this.getService().getEvent((Serializable)eventId);
        if (event != null) {
            return event;
        }
        throw new NotFoundException(ExceptionManager.objectNotFoundMsg(Event.class.getSimpleName(), eventId));
    }

    private <T> Stream<T> stream(Spliterator<T> spliterator) {
        return StreamSupport.stream(spliterator, false);
    }

    public static enum ErrorCodes {
        NO_VENUE(1),
        NO_BOAT_CLASS(2),
        LEADERBOARD_GROUP_ALREADY_EXISTS(3),
        REGATTA_ALREADY_EXISTS(4),
        LEADERBOARD_ALREADY_EXISTS(5);

        private final int errorCode;

        private ErrorCodes(int errorCode) {
            this.errorCode = errorCode;
        }

        public int getErrorCode() {
            return this.errorCode;
        }
    }
}

