/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.coursetemplate.ControlPointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationRequestAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationResponseAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationVisitor;
import com.sap.sailing.domain.coursetemplate.MarkPairWithConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplateBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.RegattaMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.impl.CourseConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.FreestyleMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPairWithConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPropertiesBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.RegattaMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointWithMarkConfigurationImpl;
import com.sap.sailing.server.gateway.deserialization.impl.CourseConfigurationBuilder;
import com.sap.sailing.server.gateway.deserialization.impl.CourseConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.DeviceIdentifierJsonDeserializer;
import com.sap.sailing.server.gateway.serialization.impl.CourseConfigurationJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.impl.PlaceHolderDeviceIdentifierJsonHandler;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.json.JsonSerializer;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Path(value="/v1/courseconfiguration")
public class CourseConfigurationResource
extends AbstractSailingServerResource {
    private static final Logger log = Logger.getLogger(CourseConfigurationResource.class.getName());
    private JsonSerializer<CourseConfiguration<MarkConfigurationResponseAnnotation>> courseConfigurationJsonSerializer;
    private final BiFunction<Regatta, DeviceIdentifier, GPSFix> positionResolver = (regatta, deviceIdentifier) -> {
        GPSFix lastPosition = null;
        try {
            Map lastFix = this.getService().getSensorFixStore().getFixLastReceived(Collections.singleton(deviceIdentifier));
            Timed t = (Timed)lastFix.get(deviceIdentifier);
            if (t instanceof GPSFix) {
                lastPosition = (GPSFix)t;
            }
        }
        catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
            log.log(Level.WARNING, "Could not load associated fix for device " + deviceIdentifier, e);
        }
        return lastPosition;
    };
    private DeviceIdentifierJsonDeserializer deviceIdentifierDeserializer;
    private TypeBasedServiceFinder<DeviceIdentifierJsonHandler> deviceJsonServiceFinder;
    public static final String FIELD_TAGS = "tags";

    private JsonDeserializer<CourseConfiguration<MarkConfigurationRequestAnnotation>> getCourseConfigurationDeserializer(Regatta regatta) {
        return new CourseConfigurationJsonDeserializer(this.getSharedSailingData(), this.getDeviceIdentifierDeserializer(), regatta);
    }

    private Response getBadRegattaErrorResponse(String regattaName) {
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadRaceErrorResponse(String regattaName, String raceColumn, String fleet) {
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)("Could not find a race with race column '" + StringEscapeUtils.escapeHtml((String)raceColumn) + "' and fleet '" + fleet + "' for regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadCourseTemplateErrorResponse(String courseTemplateId) {
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)("Could not find a CourseTemplate with ID '" + StringEscapeUtils.escapeHtml((String)courseTemplateId) + "'.")).type("text/plain").build();
    }

    private Response getBadCourseConfigurationValidationErrorResponse(String errorText) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="getFromCourse/{regattaName}/{raceColumn}/{fleet}")
    public Response createCourseConfigurationFromCourse(@PathParam(value="regattaName") String regattaName, @PathParam(value="raceColumn") String raceColumn, @PathParam(value="fleet") String fleet, @QueryParam(value="tags") List<String> tags) throws Exception {
        Course courseBase;
        if (regattaName == null || raceColumn == null || fleet == null) {
            return this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to have a regatta name and a race name");
        }
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        RaceColumn raceColumnByName = this.findRaceColumnByName(regatta, raceColumn);
        Fleet fleetByName = this.findFleetByName(raceColumnByName, fleet);
        if (raceColumnByName == null || fleetByName == null) {
            return this.getBadRaceErrorResponse(regattaName, raceColumn, fleet);
        }
        RaceDefinition raceDefinition = raceColumnByName.getRaceDefinition(fleetByName);
        if (raceDefinition != null) {
            courseBase = raceDefinition.getCourse();
        } else {
            ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.getService(), (RaceLog)raceColumnByName.getRaceLog(fleetByName));
            courseBase = raceState.getCourseDesign();
        }
        CourseConfiguration courseConfiguration = this.getService().getCourseAndMarkConfigurationFactory().createCourseConfigurationFromRegatta((CourseBase)courseBase, regatta, raceColumnByName.getTrackedRace(fleetByName), tags);
        JSONObject jsonResult = this.getCourseConfigurationJsonSerializer().serialize((Object)courseConfiguration);
        return Response.ok((Object)this.streamingOutput(jsonResult)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="getFromCourseTemplate/{courseTemplateId}")
    public Response createCourseConfigurationFromCourseTemplate(@PathParam(value="courseTemplateId") String courseTemplateId, @QueryParam(value="regattaName") String regattaName, @QueryParam(value="tags") List<String> tags, @QueryParam(value="numberOfLaps") Integer optionalNumberOfLaps) {
        CourseTemplate courseTemplate = this.getSharedSailingData().getCourseTemplateById(UUID.fromString(courseTemplateId));
        if (courseTemplate == null) {
            return this.getBadCourseTemplateErrorResponse(courseTemplateId);
        }
        Regatta regatta = null;
        if (regattaName != null && (regatta = this.findRegattaByName(regattaName)) == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        CourseConfiguration courseConfiguration = this.getService().getCourseAndMarkConfigurationFactory().createCourseConfigurationFromTemplate(courseTemplate, regatta, tags, optionalNumberOfLaps);
        return Response.ok((Object)this.streamingOutput(this.getCourseConfigurationJsonSerializer().serialize((Object)courseConfiguration))).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="createCourseTemplate")
    public Response createCourseTemplate(@QueryParam(value="regattaName") String regattaName, @QueryParam(value="markPropertiesGroupOwnership") String markPropertiesGroupOwnership, String json) throws Exception {
        if (json == null || json.isEmpty()) {
            return this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to be given as json object");
        }
        Regatta regatta = null;
        if (regattaName != null && (regatta = this.findRegattaByName(regattaName)) == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        Object parsedObject = new JSONParser().parse(json);
        if (parsedObject == null || !(parsedObject instanceof JSONObject)) {
            this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to be given as json object");
        }
        CourseConfiguration courseConfiguration = (CourseConfiguration)this.getCourseConfigurationDeserializer(regatta).deserialize((JSONObject)parsedObject);
        List<String> tags = Arrays.asList(ArrayUtils.nullToEmpty((String[])((String[])((JSONObject)parsedObject).get((Object)FIELD_TAGS))));
        Optional<UserGroup> optionalUserGroupForNonDefaultMarkPropertiesOwnership = this.getOptionalGroupOwnership(markPropertiesGroupOwnership);
        CourseConfiguration<MarkConfigurationResponseAnnotation> courseTemplate = this.annotateWithLastKnownPositionInformation(regatta, (CourseConfiguration<MarkConfigurationRequestAnnotation>)this.getService().getCourseAndMarkConfigurationFactory().createCourseTemplateAndUpdatedConfiguration(courseConfiguration, tags, optionalUserGroupForNonDefaultMarkPropertiesOwnership));
        return Response.ok((Object)this.streamingOutput(this.getCourseConfigurationJsonSerializer().serialize(courseTemplate))).build();
    }

    private CourseConfiguration<MarkConfigurationResponseAnnotation> annotateWithLastKnownPositionInformation(Regatta regatta, CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfiguration) {
        HashMap<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigMap = new HashMap<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkConfiguration<MarkConfigurationResponseAnnotation>>();
        for (MarkConfiguration sourceMark : courseConfiguration.getAllMarks()) {
            this.annotateWithLastKnownPositionInformation(regatta, (MarkConfiguration<MarkConfigurationRequestAnnotation>)sourceMark, markConfigMap);
        }
        HashMap<MarkConfiguration, MarkRole> targetAssociatedRoles = new HashMap<MarkConfiguration, MarkRole>();
        for (Map.Entry e : courseConfiguration.getAssociatedRoles().entrySet()) {
            targetAssociatedRoles.put((MarkConfiguration)markConfigMap.get(e.getKey()), (MarkRole)e.getValue());
        }
        ArrayList<WaypointWithMarkConfigurationImpl> targetWaypoints = new ArrayList<WaypointWithMarkConfigurationImpl>();
        for (WaypointWithMarkConfiguration sourceWaypoint : courseConfiguration.getWaypoints()) {
            targetWaypoints.add(new WaypointWithMarkConfigurationImpl(this.annotateWithLastKnownPositionInformation((ControlPointWithMarkConfiguration<MarkConfigurationRequestAnnotation>)sourceWaypoint.getControlPoint(), regatta, markConfigMap), sourceWaypoint.getPassingInstruction()));
        }
        return new CourseConfigurationImpl(courseConfiguration.getOptionalCourseTemplate(), new HashSet(markConfigMap.values()), targetAssociatedRoles, targetWaypoints, courseConfiguration.getRepeatablePart(), courseConfiguration.getNumberOfLaps(), courseConfiguration.getName(), courseConfiguration.getShortName(), courseConfiguration.getOptionalImageURL());
    }

    private ControlPointWithMarkConfiguration<MarkConfigurationResponseAnnotation> annotateWithLastKnownPositionInformation(ControlPointWithMarkConfiguration<MarkConfigurationRequestAnnotation> controlPoint, Regatta regatta, Map<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigMap) {
        MarkPairWithConfigurationImpl result;
        if (controlPoint instanceof MarkPairWithConfiguration) {
            MarkPairWithConfiguration sourceMarkPair = (MarkPairWithConfiguration)controlPoint;
            result = new MarkPairWithConfigurationImpl(sourceMarkPair.getName(), this.annotateWithLastKnownPositionInformation(regatta, (MarkConfiguration<MarkConfigurationRequestAnnotation>)sourceMarkPair.getLeft(), markConfigMap), this.annotateWithLastKnownPositionInformation(regatta, (MarkConfiguration<MarkConfigurationRequestAnnotation>)sourceMarkPair.getRight(), markConfigMap), sourceMarkPair.getShortName());
        } else if (controlPoint instanceof MarkConfiguration) {
            result = this.annotateWithLastKnownPositionInformation(regatta, (MarkConfiguration<MarkConfigurationRequestAnnotation>)((MarkConfiguration)controlPoint), markConfigMap);
        } else {
            throw new IllegalStateException("Unknown ControlPointWithMarkConfiguration subclass: " + controlPoint.getClass().getName());
        }
        return result;
    }

    private MarkConfiguration<MarkConfigurationResponseAnnotation> annotateWithLastKnownPositionInformation(final Regatta regatta, MarkConfiguration<MarkConfigurationRequestAnnotation> sourceMark, Map<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigMap) {
        return markConfigMap.computeIfAbsent(sourceMark, sm -> (MarkConfiguration)sm.accept((MarkConfigurationVisitor)new MarkConfigurationVisitor<MarkConfiguration<MarkConfigurationResponseAnnotation>, MarkConfigurationRequestAnnotation>(){

            public MarkConfiguration<MarkConfigurationResponseAnnotation> visit(FreestyleMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                return new FreestyleMarkConfigurationImpl(markConfiguration.getOptionalMarkTemplate(), markConfiguration.getOptionalMarkProperties(), markConfiguration.getFreestyleProperties(), (Object)CourseConfigurationResource.this.getLastKnownPositionInformation((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo(), null, CourseConfigurationResource.this.positionResolver, regatta));
            }

            public MarkConfiguration<MarkConfigurationResponseAnnotation> visit(MarkPropertiesBasedMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                return new MarkPropertiesBasedMarkConfigurationImpl(markConfiguration.getOptionalMarkProperties(), markConfiguration.getOptionalMarkTemplate(), (Object)CourseConfigurationResource.this.getLastKnownPositionInformation((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo(), null, CourseConfigurationResource.this.positionResolver, regatta));
            }

            public MarkConfiguration<MarkConfigurationResponseAnnotation> visit(MarkTemplateBasedMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                return new MarkTemplateBasedMarkConfigurationImpl(markConfiguration.getOptionalMarkTemplate(), (Object)CourseConfigurationResource.this.getLastKnownPositionInformation((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo(), null, CourseConfigurationResource.this.positionResolver, regatta));
            }

            public MarkConfiguration<MarkConfigurationResponseAnnotation> visit(RegattaMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                return new RegattaMarkConfigurationImpl(markConfiguration.getMark(), (Object)CourseConfigurationResource.this.getLastKnownPositionInformation((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo(), markConfiguration.getMark(), CourseConfigurationResource.this.positionResolver, regatta), markConfiguration.getOptionalMarkTemplate(), markConfiguration.getOptionalMarkProperties());
            }
        }));
    }

    private MarkConfigurationResponseAnnotation getLastKnownPositionInformation(MarkConfigurationRequestAnnotation positioningAnnotation, Mark regattaMark, BiFunction<Regatta, DeviceIdentifier, GPSFix> positionResolver, Regatta regatta) {
        Function<DeviceIdentifier, GPSFix> positionResolverFromDeviceIdentifier = deviceIdentifier -> (GPSFix)positionResolver.apply(regatta, (DeviceIdentifier)deviceIdentifier);
        MarkConfigurationResponseAnnotation result = regattaMark == null ? (positioningAnnotation != null ? CourseConfigurationBuilder.getPositioningIfAvailable((Positioning)positioningAnnotation.getOptionalPositioning(), positionResolverFromDeviceIdentifier) : null) : CourseConfigurationBuilder.getPositioningIfAvailable((Regatta)regatta, null, (Mark)regattaMark, positionResolverFromDeviceIdentifier);
        return result;
    }

    private Optional<UserGroup> getOptionalGroupOwnership(String optionalGroupName) {
        Optional<UserGroup> optionalUserGroupForNonDefaultMarkPropertiesOwnership = optionalGroupName != null ? Optional.of(this.getService().getSecurityService().getUserGroupByName(optionalGroupName)) : Optional.empty();
        return optionalUserGroupForNonDefaultMarkPropertiesOwnership;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="createCourse/{regattaName}/{raceColumn}/{fleet}")
    public Response createCourse(@PathParam(value="regattaName") String regattaName, @QueryParam(value="markPropertiesGroupOwnership") String markPropertiesGroupOwnership, @PathParam(value="raceColumn") String raceColumn, @PathParam(value="fleet") String fleet, String jsonCourseConfiguration) throws Exception {
        if (jsonCourseConfiguration == null || jsonCourseConfiguration.isEmpty()) {
            return this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to be given as json object");
        }
        if (regattaName == null || raceColumn == null || fleet == null) {
            return this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to have a regatta name and a race name");
        }
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
        RaceColumn raceColumnByName = this.findRaceColumnByName(regatta, raceColumn);
        Fleet fleetByName = this.findFleetByName(raceColumnByName, fleet);
        if (raceColumnByName == null || fleetByName == null) {
            return this.getBadRaceErrorResponse(regattaName, raceColumn, fleet);
        }
        Object parsedObject = new JSONParser().parse(jsonCourseConfiguration);
        if (parsedObject == null || !(parsedObject instanceof JSONObject)) {
            this.getBadCourseConfigurationValidationErrorResponse("Course configuration is required to be given as json object");
        }
        CourseConfiguration courseConfiguration = (CourseConfiguration)this.getCourseConfigurationDeserializer(regatta).deserialize((JSONObject)parsedObject);
        TimePoint timestampForLogEntries = MillisecondsTimePoint.now();
        Optional<UserGroup> optionalUserGroupForNonDefaultMarkPropertiesOwnership = this.getOptionalGroupOwnership(markPropertiesGroupOwnership);
        CourseBase course = this.getService().getCourseAndMarkConfigurationFactory().createCourseFromConfigurationAndDefineMarksAsNeeded(regatta, courseConfiguration, timestampForLogEntries, this.getService().getServerAuthor(), optionalUserGroupForNonDefaultMarkPropertiesOwnership);
        RaceLog raceLog = raceColumnByName.getRaceLog(fleetByName);
        raceLog.add((AbstractLogEvent)new RaceLogCourseDesignChangedEventImpl(timestampForLogEntries, this.getService().getServerAuthor(), raceLog.getCurrentPassId(), course, CourseDesignerMode.BY_MARKS));
        CourseConfiguration courseConfigurationResult = this.getService().getCourseAndMarkConfigurationFactory().createCourseConfigurationFromRegatta(course, regatta, raceColumnByName.getTrackedRace(fleetByName), Collections.emptyList());
        return Response.ok((Object)this.streamingOutput(this.getCourseConfigurationJsonSerializer().serialize((Object)courseConfigurationResult))).build();
    }

    private synchronized JsonSerializer<CourseConfiguration<MarkConfigurationResponseAnnotation>> getCourseConfigurationJsonSerializer() {
        if (this.courseConfigurationJsonSerializer == null) {
            this.courseConfigurationJsonSerializer = new CourseConfigurationJsonSerializer();
        }
        return this.courseConfigurationJsonSerializer;
    }

    private DeviceIdentifierJsonDeserializer getDeviceIdentifierDeserializer() {
        if (this.deviceIdentifierDeserializer == null) {
            this.deviceIdentifierDeserializer = new DeviceIdentifierJsonDeserializer(this.getDeviceJsonServiceFinder());
        }
        return this.deviceIdentifierDeserializer;
    }

    private synchronized TypeBasedServiceFinder<DeviceIdentifierJsonHandler> getDeviceJsonServiceFinder() {
        if (this.deviceJsonServiceFinder == null) {
            this.deviceJsonServiceFinder = this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class);
            this.deviceJsonServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierJsonHandler());
        }
        return this.deviceJsonServiceFinder;
    }
}

