/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/boatclasses")
public class BoatClassesResource
extends AbstractSailingServerResource {
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getBoatClasses() {
        BoatClassJsonSerializer boatClassJsonSerializer = new BoatClassJsonSerializer();
        JSONArray result = new JSONArray();
        for (BoatClass boatClass : this.getService().getBaseDomainFactory().getBoatClasses()) {
            JSONObject jsonBoatClass = boatClassJsonSerializer.serialize(boatClass);
            result.add((Object)jsonBoatClass);
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{boatClassName}")
    public Response getBoat(@PathParam(value="boatClassName") String boatClassName) {
        Response response;
        BoatClass boatClass = this.getService().getBaseDomainFactory().getBoatClass(boatClassName);
        if (boatClass == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a boat with id '" + StringEscapeUtils.escapeHtml((String)boatClassName) + "'.")).type("text/plain").build();
        } else {
            BoatClassJsonSerializer boatClassJsonSerializer = new BoatClassJsonSerializer();
            response = Response.ok((Object)this.streamingOutput(boatClassJsonSerializer.serialize(boatClass))).build();
        }
        return response;
    }
}

