/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class AbstractLeaderboardsResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(AbstractLeaderboardsResource.class.getName());

    protected boolean isValidLeaderboard(Leaderboard leaderboard) {
        boolean result;
        if (leaderboard == null) {
            logger.warning("Could not find a leaderboard with the given name");
            result = false;
        } else if (!(leaderboard instanceof HasRegattaLike)) {
            logger.warning("Specified Leaderboard does not have a RegattaLike child (is not a RegattaLeaderboard/FlexibleLeaderboard)");
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    protected JSONObject createEmptyLeaderboardJson(Leaderboard leaderboard, ResultStates resultState, Integer maxCompetitorsCount, boolean userPresentedValidRegattaSecret) throws NoWindException {
        JSONObject jsonLeaderboard = new JSONObject();
        this.writeCommonLeaderboardData(jsonLeaderboard, leaderboard, resultState, null, maxCompetitorsCount);
        JSONArray jsonCompetitorEntries = new JSONArray();
        jsonLeaderboard.put((Object)"competitors", (Object)jsonCompetitorEntries);
        for (Competitor competitor2 : Util.filter((Iterable)leaderboard.getCompetitors(), competitor -> userPresentedValidRegattaSecret || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC)) || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)))) {
            Nationality nationality;
            JSONObject jsonCompetitor = new JSONObject();
            jsonCompetitor.put((Object)"name", (Object)competitor2.getName());
            jsonCompetitor.put((Object)"shortName", (Object)competitor2.getShortName());
            String displayName = leaderboard.getDisplayName(competitor2);
            jsonCompetitor.put((Object)"displayName", (Object)(displayName == null ? competitor2.getName() : displayName));
            jsonCompetitor.put((Object)"id", (Object)competitor2.getId().toString());
            if (competitor2.hasBoat()) {
                CompetitorWithBoat competitorWithBoat = (CompetitorWithBoat)competitor2;
                jsonCompetitor.put((Object)"sailID", (Object)competitorWithBoat.getBoat().getSailID());
            }
            jsonCompetitor.put((Object)"nationality", (Object)((nationality = competitor2.getTeam().getNationality()) != null ? nationality.getThreeLetterIOCAcronym() : null));
            jsonCompetitor.put((Object)"countryCode", nationality != null ? (nationality.getCountryCode() != null ? nationality.getCountryCode().getTwoLetterISOCode() : null) : null);
            jsonCompetitor.put((Object)"rank", (Object)0);
            jsonCompetitor.put((Object)"carriedPoints", null);
            jsonCompetitor.put((Object)"netPoints", null);
            jsonCompetitorEntries.add((Object)jsonCompetitor);
            JSONObject jsonRaceColumns = new JSONObject();
            jsonCompetitor.put((Object)"raceScores", (Object)jsonRaceColumns);
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                JSONObject jsonEntry = new JSONObject();
                jsonRaceColumns.put((Object)raceColumn.getName(), (Object)jsonEntry);
                Fleet fleetOfCompetitor = raceColumn.getFleetOfCompetitor(competitor2);
                jsonEntry.put((Object)"fleet", (Object)(fleetOfCompetitor == null ? "" : fleetOfCompetitor.getName()));
                jsonEntry.put((Object)"totalPoints", null);
                jsonEntry.put((Object)"netPoints", null);
                jsonEntry.put((Object)"maxPointsReason", (Object)"");
                jsonEntry.put((Object)"rank", (Object)0);
                jsonEntry.put((Object)"isDiscarded", (Object)false);
                jsonEntry.put((Object)"isCorrected", (Object)false);
            }
        }
        return jsonLeaderboard;
    }

    protected void writeCompetitorBaseData(JSONObject jsonCompetitor, CompetitorDTO competitor, LeaderboardDTO leaderboard, boolean competitorAndBoatIdsOnly) {
        jsonCompetitor.put((Object)"id", (Object)competitor.getIdAsString());
        if (!competitorAndBoatIdsOnly) {
            jsonCompetitor.put((Object)"name", (Object)competitor.getName());
            jsonCompetitor.put((Object)"shortName", (Object)competitor.getShortName());
            String displayName = leaderboard.getDisplayName(competitor);
            jsonCompetitor.put((Object)"displayName", (Object)(displayName == null ? competitor.getName() : displayName));
            jsonCompetitor.put((Object)"sailID", competitor.hasBoat() ? ((CompetitorWithBoatDTO)competitor).getSailID() : null);
            jsonCompetitor.put((Object)"nationality", (Object)competitor.getThreeLetterIocCountryCode());
            jsonCompetitor.put((Object)"countryCode", (Object)competitor.getTwoLetterIsoCountryCode());
        }
    }

    protected void writeBoatData(JSONObject jsonBoat, BoatDTO boat, boolean competitorAndBoatIdsOnly) {
        jsonBoat.put((Object)"id", (Object)boat.getIdAsString());
        if (!competitorAndBoatIdsOnly) {
            jsonBoat.put((Object)"name", (Object)boat.getName());
            jsonBoat.put((Object)"displayName", (Object)boat.getDisplayName());
            jsonBoat.put((Object)"sailId", (Object)boat.getSailId());
            jsonBoat.put((Object)"boatClass", (Object)boat.getBoatClass().getName());
            jsonBoat.put((Object)"color", boat.getColor() != null ? boat.getColor().toString() : null);
        }
    }

    static JSONArray getDiscardingRuleAsJson(Leaderboard leaderboard) {
        JSONArray discardIndices;
        ResultDiscardingRule resultDiscardingRule = leaderboard.getResultDiscardingRule();
        if (resultDiscardingRule instanceof ThresholdBasedResultDiscardingRule) {
            ThresholdBasedResultDiscardingRule thresholdBasedResultDiscardingRule = (ThresholdBasedResultDiscardingRule)resultDiscardingRule;
            discardIndices = new JSONArray();
            int[] nArray = thresholdBasedResultDiscardingRule.getDiscardIndexResultsStartingWithHowManyRaces();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                discardIndices.add((Object)index);
                ++n2;
            }
        } else {
            discardIndices = null;
        }
        return discardIndices;
    }

    protected void writeCommonLeaderboardData(JSONObject jsonLeaderboard, Leaderboard leaderboard, ResultStates resultState, Date resultTimePoint, Integer maxCompetitorsCount) {
        jsonLeaderboard.put((Object)"name", (Object)leaderboard.getName());
        String displayName = leaderboard.getDisplayName();
        jsonLeaderboard.put((Object)"displayName", (Object)(displayName == null ? leaderboard.getName() : displayName));
        jsonLeaderboard.put((Object)"boatClass", leaderboard.getBoatClass() == null ? null : leaderboard.getBoatClass().getName());
        jsonLeaderboard.put((Object)"resultTimepoint", resultTimePoint != null ? Long.valueOf(resultTimePoint.getTime()) : null);
        jsonLeaderboard.put((Object)"delayToLiveInMillis", (Object)leaderboard.getDelayToLiveInMillis());
        jsonLeaderboard.put((Object)"resultState", (Object)resultState.name());
        jsonLeaderboard.put((Object)"type", (Object)leaderboard.getLeaderboardType().name());
        jsonLeaderboard.put((Object)"shardingLeaderboardName", (Object)ShardingType.LEADERBOARDNAME.encodeShardingInfo(leaderboard.getName()));
        JSONArray discardIndices = AbstractLeaderboardsResource.getDiscardingRuleAsJson(leaderboard);
        if (discardIndices != null) {
            jsonLeaderboard.put((Object)"discardIndexResultsStartingWithHowManyRaces", (Object)discardIndices);
        }
        if (leaderboard instanceof RegattaLeaderboard) {
            RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
            jsonLeaderboard.put((Object)"canBoatsOfCompetitorsChangePerRace", (Object)regattaLeaderboard.getRegatta().canBoatsOfCompetitorsChangePerRace());
        } else {
            jsonLeaderboard.put((Object)"canBoatsOfCompetitorsChangePerRace", (Object)false);
        }
        jsonLeaderboard.put((Object)"maxCompetitorsCount", (Object)maxCompetitorsCount);
        SettableScoreCorrection scoreCorrection = leaderboard.getScoreCorrection();
        if (scoreCorrection != null) {
            jsonLeaderboard.put((Object)"scoringComment", (Object)scoreCorrection.getComment());
            TimePoint lastUpdateTimepoint = scoreCorrection.getTimePointOfLastCorrectionsValidity();
            jsonLeaderboard.put((Object)"lastScoringUpdate", lastUpdateTimepoint != null ? Long.valueOf(lastUpdateTimepoint.asMillis()) : null);
        } else {
            jsonLeaderboard.put((Object)"scoringComment", null);
            jsonLeaderboard.put((Object)"lastScoringUpdate", null);
        }
        JSONArray jsonColumnNames = new JSONArray();
        JSONArray trackedRacesInfo = new JSONArray();
        jsonLeaderboard.put((Object)"columnNames", (Object)jsonColumnNames);
        jsonLeaderboard.put((Object)"trackedRacesInfo", (Object)trackedRacesInfo);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            jsonColumnNames.add((Object)raceColumn.getName());
            JSONObject raceColumnJson = new JSONObject();
            trackedRacesInfo.add((Object)raceColumnJson);
            raceColumnJson.put((Object)"raceColumnName", (Object)raceColumn.getName());
            JSONArray fleetsJson = new JSONArray();
            raceColumnJson.put((Object)"fleets", (Object)fleetsJson);
            for (Fleet fleet : raceColumn.getFleets()) {
                JSONObject trackedRaceInfo;
                JSONObject fleetJson = new JSONObject();
                fleetsJson.add((Object)fleetJson);
                fleetJson.put((Object)"name", (Object)fleet.getName());
                fleetJson.put((Object)"resultsAreOfficial", (Object)leaderboard.isResultsAreOfficial(raceColumn, fleet));
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace == null) {
                    trackedRaceInfo = null;
                } else {
                    trackedRaceInfo = new JSONObject();
                    trackedRaceInfo.put((Object)"name", (Object)trackedRace.getRace().getName());
                    trackedRaceInfo.put((Object)"id", (Object)trackedRace.getRace().getId().toString());
                    TimePoint startOfRace = trackedRace.getStartOfRace();
                    trackedRaceInfo.put((Object)"startTimeMillis", startOfRace == null ? null : Long.valueOf(startOfRace.asMillis()));
                    trackedRaceInfo.put((Object)"live", (Object)trackedRace.isLive((TimePoint)(resultTimePoint == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : new MillisecondsTimePoint(resultTimePoint))));
                    trackedRaceInfo.put((Object)"delayToLiveInMillis", (Object)trackedRace.getDelayToLiveInMillis());
                    if (trackedRace.getStatus() != null) {
                        trackedRaceInfo.put((Object)"status", (Object)trackedRace.getStatus().getStatus().toString());
                        trackedRaceInfo.put((Object)"loadingProgress", (Object)trackedRace.getStatus().getLoadingProgress());
                    }
                }
                fleetJson.put((Object)"trackedRace", (Object)trackedRaceInfo);
            }
        }
    }

    protected TimePoint calculateTimePointForResultState(Leaderboard leaderboard, ResultStates resultState) {
        TimePoint result = null;
        switch (resultState) {
            case Live: {
                result = null;
                break;
            }
            case Final: {
                if (leaderboard.getScoreCorrection() == null || leaderboard.getScoreCorrection().getTimePointOfLastCorrectionsValidity() == null) break;
                result = leaderboard.getScoreCorrection().getTimePointOfLastCorrectionsValidity();
                for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                    Iterable markPassingsForFirstWaypoint;
                    Waypoint firstWaypoint;
                    TimePoint endOfRace = trackedRace.getEndOfRace();
                    if (endOfRace != null || (firstWaypoint = trackedRace.getRace().getCourse().getFirstWaypoint()) == null || (markPassingsForFirstWaypoint = trackedRace.getMarkPassingsInOrder(firstWaypoint)) == null) continue;
                    trackedRace.lockForRead(markPassingsForFirstWaypoint);
                    try {
                        Iterator i = markPassingsForFirstWaypoint.iterator();
                        if (!i.hasNext()) continue;
                        TimePoint earliestMarkPassingTimePoint = ((MarkPassing)i.next()).getTimePoint();
                        if (result != null && !earliestMarkPassingTimePoint.before(result)) continue;
                        result = earliestMarkPassingTimePoint.minus(1L);
                    }
                    finally {
                        trackedRace.unlockAfterRead(markPassingsForFirstWaypoint);
                    }
                }
                break;
            }
        }
        return result;
    }

    protected abstract JSONObject getLeaderboardJson(Leaderboard var1, TimePoint var2, ResultStates var3, Integer var4, List<String> var5, List<String> var6, boolean var7, List<String> var8, boolean var9, boolean var10) throws NoWindException, InterruptedException, ExecutionException;

    protected JSONObject getLeaderboardJson(ResultStates resultState, Integer maxCompetitorsCount, TimePoint requestTimePoint, Leaderboard leaderboard, TimePoint timePoint, List<String> raceColumnNames, List<String> raceDetailNames, boolean competitorAndBoatIdsOnly, List<String> showOnlyActiveRacesForCompetitorIds, boolean userPresentedValidRegattaSecret, boolean showOnlyCompetitorsWithIdsProvided) throws NoWindException, InterruptedException, ExecutionException {
        JSONObject jsonLeaderboard = timePoint != null || resultState == ResultStates.Live ? this.getLeaderboardJson(leaderboard, timePoint, resultState, maxCompetitorsCount, raceColumnNames, raceDetailNames, competitorAndBoatIdsOnly, showOnlyActiveRacesForCompetitorIds, userPresentedValidRegattaSecret, showOnlyCompetitorsWithIdsProvided) : this.createEmptyLeaderboardJson(leaderboard, resultState, maxCompetitorsCount, userPresentedValidRegattaSecret);
        return jsonLeaderboard;
    }

    public static enum ResultStates {
        Live,
        Final;

    }
}

