/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.serialization.impl.DeviceConfigurationJsonSerializer;
import com.sap.sse.security.shared.HasPermissions;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONObject;

public class ConfigurationJsonGetServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 7704668926551060433L;
    public static final String PARAMS_CLIENT_ID = "client";
    public static final String PARAMS_CLIENT_UUID = "uuid";
    private static final Logger logger = Logger.getLogger(ConfigurationJsonGetServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String configurationName = request.getParameter(PARAMS_CLIENT_ID);
        String configurationUuidAsString = request.getParameter(PARAMS_CLIENT_UUID);
        if (configurationName == null && configurationUuidAsString == null) {
            response.sendError(400, String.format("Missing parameter: one of '%s' and '%s' must be provided.", PARAMS_CLIENT_ID, PARAMS_CLIENT_UUID));
        } else {
            DeviceConfiguration configuration;
            if (configurationName != null) {
                logger.fine(String.format("Configuration requested by client %s.", configurationName));
                configuration = this.getService().getDeviceConfigurationByName(configurationName);
            } else {
                logger.fine(String.format("Configuration requested by id %s.", configurationUuidAsString));
                configuration = this.getService().getDeviceConfigurationById(UUID.fromString(configurationUuidAsString));
            }
            if (configuration != null) {
                SecurityUtils.getSubject().checkPermission(configuration.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
                DeviceConfigurationJsonSerializer serializer = DeviceConfigurationJsonSerializer.create();
                JSONObject json = serializer.serialize((Object)configuration);
                response.setCharacterEncoding("UTF-8");
                json.writeJSONString((Writer)response.getWriter());
            } else {
                response.sendError(404, "No configuration for given identifier.");
            }
        }
    }
}

